#include "square.h"

int diagonal_a8h1_inverse_map[64];
int diagonal_a1h8_inverse_map[64];
int diagonal_a8h1_square[64];
int diagonal_a1h8_square[64];
int diagonal_a8h1_offset[64];
int diagonal_a1h8_offset[64];
int diagonal_a8h1_ord[64];
int diagonal_a1h8_ord[64];
int diagonal_a8h1_diagonal[64];
int diagonal_a1h8_diagonal[64];

void construct_inverse_diagonal_maps(void)
{
   int n;

   for (n=0; n<64; n++) {
      diagonal_a8h1_inverse_map[calculate_a8h1_diagonal_square(n)] = n;
      diagonal_a1h8_inverse_map[calculate_a1h8_diagonal_square(n)] = n;
      diagonal_a8h1_square[n] = calculate_a8h1_diagonal_square(n);
      diagonal_a1h8_square[n] = calculate_a1h8_diagonal_square(n);
      diagonal_a8h1_offset[n] = calculate_a8h1_diagonal_offset(n);
      diagonal_a1h8_offset[n] = calculate_a1h8_diagonal_offset(n);
      diagonal_a8h1_ord[n] = calculate_a8h1_diagonal_ord(n);
      diagonal_a1h8_ord[n] = calculate_a1h8_diagonal_ord(n);
      diagonal_a8h1_diagonal[n] = calculate_a8h1_diagonal(n);
      diagonal_a1h8_diagonal[n] = calculate_a1h8_diagonal(n);
   }
}

