#include "move.h"
#include "names.h"
#include "pieces.h"
#include "squares.h"
#include "square.h"

static const char *file_names[8] = { "a", "b", "c", "d", "e", "f", "g", "h" };
static const char *row_names[8] = { "1", "2", "3", "4", "5", "6", "7", "8" };
static char static_output_buffer[16];

move_t irreversible_move;

char *short_move_string(const move_t move, movelist_t *movelist, char *buffer)
{
   char *s = buffer;
   const char *piece = "";
   const char *suffix = "";
   const char *token = "";
   const char *origin = "";
   int p = get_move_piece(move)&(PIECE^PAWN);

   if (!s) s = static_output_buffer;

   if (move.m == 0) {
      snprintf(s, 15, "...");
      return s;
   }

   if (is_castling(move)) {
      if (move.castle & 1)
         snprintf(s, 15, " O-O-O");
      else
         snprintf(s, 15, " O-O");
      return s;
   }

   if (is_capture(move)) token = "x";
   if (is_enpassant(move)) suffix = "ep";
   if (is_promotion(move)) suffix = piece_str[piece_index[move.tpiece&PIECE]];
   if (p) piece = piece_str[piece_index[p]];

   /* Slightly special case: pawn capture */
   if (!p && is_capture(move)) {
      origin = file_names[unpack_column(move.from)];
   } else if (p && movelist) {
      /* The information we have now might be ambiguous - check */
      int count = 0;
      int n;
      for (n=0; n<movelist->num_moves; n++) {
         if (move.piece == movelist->move[n].piece &&
             move.to == movelist->move[n].to) count++;
      }
      if (count <= 1) goto disambiguous;

      /* Try to disambiguate by file */
      count = 0;
      for (n=0; n<movelist->num_moves; n++) {
         if (move.piece == movelist->move[n].piece &&
             move.to == movelist->move[n].to &&
             unpack_column(move.from) == unpack_column(movelist->move[n].from))
            count++;
      }
      if (count == 1) {
         origin = file_names[unpack_column(move.from)];
      } else {
         /* Disambiguate by row */
         origin = row_names[unpack_row(move.from)];
      }
   }
disambiguous:

   snprintf(s, 15, "%s%s%s%s%s", piece,
            origin, token, square_str[move.to],
            suffix);

   return s;
}

char *move_string(const move_t move, char *buffer)
{
   char *s = buffer;
   const char *piece = "";
   const char *suffix = "";
   const char *token = "-";
   int p = get_move_piece(move)&PIECE;

   if (!s) s = static_output_buffer;

   if (move.m == 0) {
      snprintf(s, 15, "...");
      return s;
   }

   if (is_castling(move)) {
      if (move.castle & 1)
         snprintf(s, 15, " O-O-O");
      else
         snprintf(s, 15, " O-O");
      return s;
   }

   if (is_capture(move)) token = "x";
   if (is_enpassant(move)) suffix = "ep";
   if (is_promotion(move)) suffix = piece_str[piece_index[move.tpiece&PIECE]];
   if (p) piece = piece_str[piece_index[p]];

   snprintf(s, 15, "%s%2s%s%2s%s", piece,
            square_str[move.from], token, square_str[move.to],
            suffix);

   return s;
}
