#include <string.h>
#include "board.h"
#include "pieces.h"

void clear_board(board_t *board)
{
   memset(board, 0, sizeof *board);
}

void begin_board(board_t *board)
{
   int c;
   
   clear_board(board);

   /* Place pieces */
   for (c=0; c<8; c++) {
      place_piece(board, A2+c, PAWN|WHITE);
      place_piece(board, A7+c, PAWN|BLACK);
   }

   place_piece(board, A1, ROOK|WHITE);
   place_piece(board, H1, ROOK|WHITE);
   place_piece(board, A8, ROOK|BLACK);
   place_piece(board, H8, ROOK|BLACK);

   place_piece(board, B1, KNIGHT|WHITE);
   place_piece(board, G1, KNIGHT|WHITE);
   place_piece(board, B8, KNIGHT|BLACK);
   place_piece(board, G8, KNIGHT|BLACK);

   place_piece(board, C1, BISHOP|WHITE);
   place_piece(board, F1, BISHOP|WHITE);
   place_piece(board, C8, BISHOP|BLACK);
   place_piece(board, F8, BISHOP|BLACK);

   place_piece(board, E1, KING|WHITE);
   place_piece(board, E8, KING|BLACK);

   place_piece(board, D1, QUEEN|WHITE);
   place_piece(board, D8, QUEEN|BLACK);

   /* Set "initial position" bitboard */
   for (c=0; c<16; c++) {
      set_bitboard(&(board->init), A1+c);
      set_bitboard(&(board->init), A7+c);
   }

   /* Initialise the material counter */
   count_material(board);
}

/* Counts the material on the board */
/* Only needed to initialize, since the movement code will keep track of it */
void count_material(board_t *board)
{
   int c;
   
   board->material[0] = 0;
   board->material[1] = 0;
   
   for(c=0; c<64; c++) {
      int piece = get_piece(board, c);
      int colour = (piece & BLACK)>>7;
      piece &= WOOD;
      if (piece) {
         board->material[colour] += piece_value(piece);
      }
   }
}


static void print_uint8(uint8_t b)
{
   int c;
   
   for (c=0; c<8; c++) {
      printf ("%d", (b>>c)&1);
   }
}

void print_bitboards(board_t *board)
{
   int c;

   printf("White pieces\tBlack pieces\tUnmoved pieces\tFlipped \tRotated+\tRotated-\n");
   for (c=7; c>=0; c--) {
      print_uint8(get_bitboard_row(board->bbc[0], c));
      printf("\t");
      print_uint8(get_bitboard_row(board->bbc[1], c));
      printf("\t");
      print_uint8(get_bitboard_row(board->init, c));
      printf("\t");
      print_uint8(get_bitboard_row(board->bbf, c));
      printf("\t");
      print_uint8(get_bitboard_row(board->bbr[0], c));
      printf("\t");
      print_uint8(get_bitboard_row(board->bbr[1], c));
      printf("\n");
   }

   printf("\nPawns     Knights   Bishops   Rooks     Queens    Kings\n");
   for (c=7; c>=0; c--) {
      print_uint8(get_bitboard_row(board->bbp[0], c));
      printf("  ");
      print_uint8(get_bitboard_row(board->bbp[1], c));
      printf("  ");
      print_uint8(get_bitboard_row(board->bbp[2], c));
      printf("  ");
      print_uint8(get_bitboard_row(board->bbp[3], c));
      printf("  ");
      print_uint8(get_bitboard_row(board->bbp[4], c));
      printf("  ");
      print_uint8(get_bitboard_row(board->bbp[5], c));
      printf("\n");
   }

   /*
   printf("\nBoard-a   Board-h   Centre    X-centre  K-half    Q-half\n");
   for (c=7; c>=0; c--) {
      print_uint8(get_bitboard_row(board_minus_a, c));
      printf("  ");
      print_uint8(get_bitboard_row(board_minus_h, c));
      printf("  ");
      print_uint8(get_bitboard_row(board_centre, c));
      printf("  ");
      print_uint8(get_bitboard_row(board_xcentre, c));
      printf("  ");
      print_uint8(get_bitboard_row(board_kwing, c));
      printf("  ");
      print_uint8(get_bitboard_row(board_qwing, c));
      printf("\n");
   }

   printf("\n1strank   2ndrank   7thrank   8thrank                   \n");
   for (c=7; c>=0; c--) {
      print_uint8(get_bitboard_row(board_rank1, c));
      printf("  ");
      print_uint8(get_bitboard_row(board_rank2, c));
      printf("  ");
      print_uint8(get_bitboard_row(board_rank7, c));
      printf("  ");
      print_uint8(get_bitboard_row(board_rank8, c));
      printf("  ");
      print_uint8(get_bitboard_row(0, c));
      printf("  ");
      print_uint8(get_bitboard_row(0, c));
      printf("\n");
   }
   */
}
