#include "bitboard.h"

static void print_uint8_t(uint8_t b)
{
   int c;
   
   for (c=0; c<8; c++) {
      printf ("%d", (b>>c)&1);
   }
}

/* This function prints a bitboard in such a way that 'A1' ends up on the
 * lower left corner and 'H8' ends up at the upper right corner.
 */
void printf_bitboard(bitboard_t b)
{
   int c;

   printf("+--------+\n");
   for (c=7; c>=0; c--) {
      printf("|");
      print_uint8_t(get_bitboard_row(b, c));
      printf("|\n");
   }
   printf("+--------+\n");
}
