#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>

#include "movegen.h"
#include "game.h"
#include "inline/game.h"
#include "hashtable.h"
#include "fen.h"
#include "computer.h"
#include "alphabeta.h"

static sig_t old_signal_handler;

void interrupt_computer(int i)
{
   abort_search = true;
   if (old_signal_handler)
      old_signal_handler(i);
}

int main(void)
{
   gamestate_t *game = NULL;
   movelist_t movelist;
   char *str;
   FILE *file;
   int n;
   char *move;
   char *bm;
   int correct;
   int time_remaining;
   int number_of_positions;

   printf("Welcome to Jazz\n");
   printf("Memory sizes:\n"
          " * move_t     : %lu bytes\n"
          " * bitboard_t : %lu bytes\n"
          " * hash_table_: %lu bytes\n"
          " * board_t    : %lu bytes\n",
          sizeof(move_t),
          sizeof(bitboard_t),
          sizeof(hash_table_entry_t),
          sizeof(board_t));
   printf("Size of transposition table: %lu bytes\n",
         sizeof(hash_table_entry_t) * HASH_TABLE_SIZE);

   printf("Initialising Jazz engine\n");
   playgame_init();
   construct_inverse_diagonal_maps();
   generate_movement_tables();

   //file = fopen("data/epd/wac.epd", "r");
   file = fopen("data/epd/ecmgcp.epd", "r");
   if (!file) return 0;

   str = malloc(256);

   old_signal_handler = signal(SIGALRM, interrupt_computer);
   correct = 0;
   time_remaining = 0;
   number_of_positions = 0;
   for (n=0; n<300; n++) {
      int result;
      bool eof = false;

      eof = !fgets(str, 256, file);

      game = load_fen_position(str);
      if (!game) {
         printf("could not load file\n");
         exit(0);
      }
      generate_moves(&movelist, game->board, game->player);

      bm = strstr(str, "bm");
      if (bm) {
         char *p;
         bm+=3;
         p = strstr(bm, "+");
         if (p) *p =' ';
         p = strstr(bm, ";");
         if (p) *p ='\0';
      } else {
         bm = "???";
      }

      printf("--------------------------------------------------------\n");
      printf("Test position %d\n", n+1);

      /* Interrupt the computer after 10 seconds */
      alarm(10);
      computer_play(game, 40);
      /* cancel the alarm if it hasn't gone off yet */
      time_remaining += alarm(0);

      move = short_move_string(game->move_list[0], &movelist, NULL);

      if (strstr(bm, " ")) {
         result = (strstr(bm, move) != NULL);
      } else {
         result = (strcmp(move, bm)==0);
      }
      correct+=result;
      number_of_positions++;

      printf("Position %d, selected move %s, best move %s (%s, %d/%d)\n",
            n+1, move, bm, result?"correct":"wrong", correct, number_of_positions);
      end_game(game);

      if (eof)
         break;
   }
   printf("All done, %d seconds remaining.\n", time_remaining);

   return 0;
}
