#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>

#include "movegen.h"
#include "game.h"
#include "inline/game.h"
#include "hashtable.h"
#include "fen.h"
#include "computer.h"
#include "alphabeta.h"
#include "board.h"

extern uint64_t get_timer(void);

uint64_t perft(gamestate_t *game, int depth)
{
   movelist_t movelist;
   int me = game->player;
   uint64_t nodes = 0;
   int n;

   if (depth == 0) return 1;

   generate_moves(&movelist, game->board, game->player);
   for (n=0; n<movelist.num_moves; n++) {

      playmove(game, movelist.move[n]);
      if (!player_in_check(game, me))  /* Don't count illegal moves */
         nodes += perft(game, depth-1);
      takeback_no_check(game);
   }
   return nodes;
}

int main(void)
{
   gamestate_t *game = NULL;
   uint64_t t;
   int n;

   printf("Welcome to Jazz\n");
   printf("Memory sizes:\n"
          " * move_t     : %lu bytes\n"
          " * bitboard_t : %lu bytes\n"
          " * hash_table_: %lu bytes\n"
          " * board_t    : %lu bytes\n",
          sizeof(move_t),
          sizeof(bitboard_t),
          sizeof(hash_table_entry_t),
          sizeof(board_t));
   printf("Size of transposition table: %lu bytes\n",
         sizeof(hash_table_entry_t) * HASH_TABLE_SIZE);

   printf("Initialising Jazz engine\n");
   playgame_init();
   construct_inverse_diagonal_maps();
   generate_movement_tables();

   //printf("Initialising new game\n");
   game = create_game();
   start_new_game(game);

   t = get_timer();
   for (n = 0; n<6; n++) {
      uint64_t nodes = perft(game, n);
      uint64_t tt = get_timer();

      if (tt == t) tt++;

      printf("%2d %8lld %4.2f %12.2f\n", n, nodes,
         (tt - t)/1000000.0,nodes*1.0e6/(tt-t));

      t = tt;
   }

   return 0;
}

