#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "movegen.h"
#include "game.h"
#include "inline/game.h"
#include "hashtable.h"
#include "fen.h"
#include "computer.h"
#include "alphabeta.h"
#include "timer.h"

int main(void)
{
   gamestate_t *game = NULL;
   movelist_t movelist;

   printf("Welcome to Jazz\n");
   printf("Memory sizes:\n"
          " * move_t     : %lu bytes\n"
          " * bitboard_t : %lu bytes\n"
          " * hash_table_: %lu bytes\n"
          " * board_t    : %lu bytes\n",
          sizeof(move_t),
          sizeof(bitboard_t),
          sizeof(hash_table_entry_t),
          sizeof(board_t));
   printf("Size of transposition table: %lu bytes\n",
         sizeof(hash_table_entry_t) * HASH_TABLE_SIZE);

   printf("Initialising Jazz engine\n");
   playgame_init();
   construct_inverse_diagonal_maps();
   generate_movement_tables();

   //printf("Initialising new game\n");
   //game = create_game();
   //start_new_game(game);

   /* Solved in 0.391s */
   game = load_epd_file("data/epd/Sam Loyd American Chess Nuts 1868 - Mate in 5.epd");

   /* Solved in 0.087s */
   //game = load_epd_file("data/epd/mate_in_8.epd");

   /* Solved in 1.182 */
   //game = load_epd_file("data/epd/mate_in_9.epd");

   /* Solved in 2.519s */
   //game = load_epd_file("data/epd/wac211.epd");

   /* Seen at 7 ply in ~0.5 s */
   //game = load_epd_file("data/epd/Fischer - Reshevski.epd");

   /* Solved in slightly less than 10 seconds */
   //game = load_epd_file("data/epd/wac293.epd");
   //game = load_epd_file("data/epd/wac256.epd");

   //game = load_epd_file("data/epd/wac087.epd");
   //game = load_epd_file("data/epd/wac049.epd");
   //game = load_epd_file("data/epd/wac250.epd");
   //game = load_epd_file("data/epd/wac.epd");

   //game = load_epd_file("data/epd/fastmates.epd");
   //game = load_epd_file("data/epd/wac.epd");
   //game = load_epd_file("data/epd/kopec.epd");
   //game = load_epd_file("data/epd/stap3+p15-1.epd");
   //game = load_epd_file("horizon.epd");

   //game = load_epd_file("data/epd/ecmgcp177.epd");

   if (!game) {
      printf("could not load file\n");
      exit(0);
   }
   //set_time_per_move(game, 5000);
   generate_moves(&movelist, game->board, game->player);
   print_bitboards(game->board);

   computer_play(game, 12);
   //computer_play(game, 10);
   //computer_play(game, 8);
   //computer_play(game, 12);

   /* Promotion test */
   //remove_piece(game->board, E8);
   //remove_piece(game->board, E7);
   //place_piece(game->board, E7, PAWN|WHITE);
   //playmove(game, encode_promotion_move(QUEEN|WHITE, E7, E8));
   //print_bitboards(game->board);
   //generate_moves(&movelist, game->board, game->player);

   //playmove(game, encode_normal_move(KNIGHT|WHITE, G1, F3));
   //playmove(game, encode_normal_move(PAWN|WHITE, D2, D4));
   //playmove(game, encode_normal_move(PAWN|BLACK, D7, D5));
   //playmove(game, encode_normal_move(PAWN|WHITE, E2, E4));
   //playmove(game, encode_normal_move(PAWN|BLACK, E7, E5));
   //playmove(game, encode_normal_move(KNIGHT|WHITE, G1, F3));
   //takeback(game);
   //printf_bitboard(game->board->bbp[0]);
   //generate_moves(&movelist, game->board, game->player);

   /* Castling test, King side */
   //playmove(game, encode_normal_move(KNIGHT|WHITE, G1, F3));
   //playmove(game, encode_normal_move(PAWN|WHITE, G2, G3));
   //playmove(game, encode_normal_move(BISHOP|WHITE, F1, G2));

   //playmove(game, encode_normal_move(KNIGHT|BLACK, G8, F6));
   //playmove(game, encode_normal_move(PAWN|BLACK, G7, G6));
   //playmove(game, encode_normal_move(BISHOP|BLACK, F8, G7));

   //playmove(game, encode_castling(KING|WHITE, E1, G1, castlek_rook_bits));
   //playmove(game, encode_castling(KING|BLACK, E8, G8, castlek_rook_bits));
   //print_bitboards(game->board);
   //generate_moves(&movelist, game->board, WHITE);
   //generate_moves(&movelist, game->board, BLACK);

   /* Castling test, Queen side */
   //playmove(game, encode_normal_move(KNIGHT|WHITE, B1, C3));
   //playmove(game, encode_normal_move(PAWN|WHITE, B2, B3));
   //playmove(game, encode_normal_move(BISHOP|WHITE, C1, B2));

   //playmove(game, encode_normal_move(KNIGHT|BLACK, B8, C6));
   //playmove(game, encode_normal_move(PAWN|BLACK, B7, B6));
   //playmove(game, encode_normal_move(BISHOP|BLACK, C8, B7));


   //remove_piece(game->board, D1);
   //remove_piece(game->board, D8);

   //playmove(game, encode_castling(KING|WHITE, E1, C1, castleq_rook_bits));
   //playmove(game, encode_castling(KING|BLACK, E8, C8, castleq_rook_bits));
   //print_bitboards(game->board);
   //generate_moves(&movelist, game->board, WHITE);
   //generate_moves(&movelist, game->board, BLACK);

   /* En-passant test */
   //playmove(game, encode_normal_move(PAWN|WHITE, E2, E5));
   //playmove(game, encode_normal_move(PAWN|WHITE, C2, C5));
   //playmove(game, encode_doublep_move(PAWN|BLACK, D7, D5, D6));
   //print_bitboards(game->board);
   //generate_moves(&movelist, game->board, game->player);
   //playmove(game, encode_enpassant_capture(PAWN|WHITE, E5, D6, D6-8));
   //print_bitboards(game->board);

   return 0;
}
