#include "names.h"
#include "board.h"
#include "game.h"

void setup_fen_position(gamestate_t *game, const char *str)
{
   const char *s = str;
   int square;

   assert(game);
   if (!s) return;
   game->board = game->board_list;
   game->moves_played = 0;
   clear_board(game->board);

   /* Parse first record: piece positions */
   square = A8;
   while(*s && (*s != ' ')) {
      switch (*s) {
         case '/':
            square -= 15;
         case '1':
         case '2':
         case '3':
         case '4':
         case '5':
         case '6':
         case '7':
         case '8':
            square += (*s - '1')+1;
            break;

         case 'p':
            place_piece(game->board, square, PAWN|BLACK);
            square++;
            break;
         case 'n':
            place_piece(game->board, square, KNIGHT|BLACK);
            square++;
            break;
         case 'b':
            place_piece(game->board, square, BISHOP|BLACK);
            square++;
            break;
         case 'r':
            place_piece(game->board, square, ROOK|BLACK);
            square++;
            break;
         case 'q':
            place_piece(game->board, square, QUEEN|BLACK);
            square++;
            break;
         case 'k':
            place_piece(game->board, square, KING|BLACK);
            square++;
            break;

         case 'P':
            place_piece(game->board, square, PAWN|WHITE);
            square++;
            break;
         case 'N':
            place_piece(game->board, square, KNIGHT|WHITE);
            square++;
            break;
         case 'B':
            place_piece(game->board, square, BISHOP|WHITE);
            square++;
            break;
         case 'R':
            place_piece(game->board, square, ROOK|WHITE);
            square++;
            break;
         case 'Q':
            place_piece(game->board, square, QUEEN|WHITE);
            square++;
            break;
         case 'K':
            place_piece(game->board, square, KING|WHITE);
            square++;
            break;
            
      }
      s++;
   }

   /* Second record: colour */
   while(*s && (*s == ' ')) s++;
   if (*s == 'b') game->player = BLACK;
   if (*s) s++;
   game->board->hash ^= move_colour_key[game->player>>7];

   /* Third record: castling rights */
   /* FIXME: we need to parse this; however, the code will make the correct
    * default assumption (castling is possible if king and rooks are in
    * their initial positions) for most cases anyway.
    */
   while(*s && (*s == ' ')) s++;
   while(*s && (*s != ' ')) s++;
   if (*s) s++;

   /* Fourth record: En-passant square */
   while(*s && (*s == ' ')) s++;
   if (*s && (*s != '-')) {
      int col = *s - 'a';
      int row = s[1] - '1';
      s+=2;
      game->board->ep_square = pack_row_column(row, col);
   }
   /* Don't care about the rest for now... */ 

   /* Initialise the material counter */
   count_material(game->board);

   memset(game->repetition_hash_table, 0, sizeof game->repetition_hash_table);
   game->repetition_hash_table[game->board->hash&0xFFFF] = 1;
}

gamestate_t *load_fen_position(const char *fen)
{
   gamestate_t *game = NULL;

   game = create_game();
   start_new_game(game);
   setup_fen_position(game, fen);

   return game;
}

gamestate_t *load_epd_file(const char *filename)
{
   gamestate_t *game = NULL;
   char *str;
   FILE *file;

   file = fopen(filename, "r");
   if (!file) return NULL;

   str = malloc(256);
   fgets(str, 256, file);
   fclose(file);

   game = load_fen_position(str);

   free(str);
   return game;
}
