#include <stdio.h>
#include <stdint.h>
#include "genrand.h"
#include "squares.h"

uint64_t genrand64(void)
{
   return ((uint64_t)genrandui())<<32 | genrandui();

}

int main(void)
{
   uint64_t piece_key[2][6][64];
   const char *colour_names[2] = { "White", "Black" };
   const char *piece_names[6] = { "Pawn", "Knight", "Bishop", "Rook", "Queen", "King" };
   int colour, piece, square;
   /* Key reads roughly as 'Jazz chess' */
   sgenrand(0x1422CE55);

   /* Generate hashkeys for 64 squares, 2 colours and 6 pieces */
   printf("static const uint64_t piece_key[2][6][64] = {\n");
   for (colour = 0; colour<2; colour++) {
      printf(" { /* %s */\n", colour_names[colour]);
      for(piece = 0; piece<6; piece++) {
         printf("  { /* %s */\n", piece_names[piece]);
         for(square = 0; square<64; square++) {
            piece_key[colour][piece][square] = genrand64();
            printf("0x%016llxll, ", piece_key[colour][piece][square]);
            if ( (square+1)%4 == 0) printf("\n");
         }
         printf("\n");
         printf("  },\n");
      }
      printf(" },\n");
   }
   printf("};\n");

   printf("static const uint64_t move_colour_key[2] = { 0, 0x%016llxll };\n",
            genrand64());

   /* XOR hashkeys for the moving rook, during a castling move.
    * Precomputed for convenience. The first index is the colour, the
    * second index is queen/king side
    */
   printf("static const uint64_t castle_rook_key[2][2] = {\n");
   printf(" { 0x%016llxll, 0x%016llxll }, { 0x%016llxll, 0x%016llxll }\n",
      piece_key[0][3][A1]^piece_key[0][3][D1],
      piece_key[0][3][H1]^piece_key[0][3][F1],
      piece_key[1][3][A8]^piece_key[1][3][D8],
      piece_key[1][3][H8]^piece_key[1][3][F8]);
   printf("};\n");

   return 0;
}
