#include <ctype.h>
#include "names.h"
#include "board.h"
#include "game.h"

void write_epd_file(gamestate_t *game, const char *filename)
{
   FILE *f;
   int empty_count;
   int file;
   int row;
   char p;

   f = fopen(filename, "w");
   if (!f)
      return;

   /* Write FEN string for this position */
   for (row=7; row>=0; row--) {
      empty_count = 0;
      for (file=0; file<8; file++) {
         int square = pack_row_column(row, file);
         int piece = get_piece(game->board, square);
         if (!piece) {
            empty_count++;
         } else {
            if (empty_count)
               fprintf(f, "%d", empty_count);
            empty_count = 0;
            p = piece_str[piece_index[piece&PIECE]][0];
            if (piece & BLACK)
               p = tolower(p);
            fprintf(f, "%c", p);
         }
      }
      if (empty_count)
         fprintf(f, "%d", empty_count);
      fprintf(f, "/");
   }

   /* Second record: colour */
   if (game->player & BLACK)
      fprintf(f, " b");
   else
      fprintf(f, " w");

   /* Third record: castling rights */
   /* FIXME: we need to write this out properly... */
   fprintf(f, " KQkq");

   /* Fourth record: En-passant square */
   if (game->board->ep_square) {
      fprintf(f, " %s", square_str[game->board->ep_square]);
   } else {
      fprintf(f, " -");
   }
   /* Don't care about the rest... */ 

   fprintf(f, "\n");
}
