#include <stdint.h>
#include "piece_tables.h"

/* Piece square tables: these are really rule-of-thumb tables. Things like
 * the bonus for an advanced pawn is not awarded here, but in the function
 * that evaluates passed pawns.
 */
const int8_t piece_square_table[7][2][64] = {
   /*
    * Pawns
    * based on Berliner's evaluation of regular pawns, slightly modified to
    * keep the pawn shield in tact and to encourage pawn pushes to the
    * centre.
    */
#ifdef BERLINER_PAWN_TABLES
   { /* White */
      {
           0,  0,  0,  0,  0,  0,  0,  0,
          -5,  5,  5, 10, 10,  5,  5,  -5,
         -10,  0,  0, 15, 15,  0,  0, -10,
         -10,  0,  0, 20, 20,  0,  0, -10,
          -5,  3, 17, 27, 27, 17,  3,  -5,
           5, 12, 25, 40, 40, 25, 12,   5,
           5, 12, 25, 40, 40, 25, 12,   5,
         -10,  0,  0,  0,  0,  0,  0, -15,
      },
      { /* Black */
           0,  0,  0,  0,  0,  0,  0,   0,
           5, 12, 25, 40, 40, 25, 12,   5,
           5, 12, 25, 40, 40, 25, 12,   5,
          -5,  3, 17, 27, 27, 17,  3,  -5,
         -10,  0,  0, 20, 20,  0,  0, -10,
         -10,  0,  0, 15, 15,  0,  0, -10,
          -5,  5,  5, 10, 10,  5,  5,  -5,
           0,  0,  0,  0,  0,  0,  0,   0,
      }
   },
#else
   { /* White */
      {
         -15,  0,  0,  0,  0,  0,  0, -15,
          -5,  5,  5,  0,  0,  5,  5,  -5,
         -15,  0,  0,  0,  0,  0,  0, -15,
         -15,  0,  0, 20, 20,  0,  0, -15,
         -15,  0,  0,  0,  0,  0,  0, -15,
         -15,  0,  0,  0,  0,  0,  0, -15,
          -5,  5,  5,  0,  0,  5,  5,  -5,
         -15,  0,  0,  0,  0,  0,  0, -15,
      },
      { /* Black */
         -15,  0,  0,  0,  0,  0,  0, -15,
          -5,  5,  5,  0,  0,  5,  5,  -5,
         -15,  0,  0,  0,  0,  0,  0, -15,
         -15,  0,  0,  0,  0,  0,  0, -15,
         -15,  0,  0, 20, 20,  0,  0, -15,
         -15,  0,  0,  0,  0,  0,  0, -15,
          -5,  5,  5,  0,  0,  5,  5,  -5,
         -15,  0,  0,  0,  0,  0,  0, -15,
      }
   },
#endif

   /*
    * Knights
    */
   { /* White */
      {
         0, 2,  4,  6,  6,  4, 2, 0,
         2, 4,  6,  6,  6,  6, 4, 2,
         4, 6,  8, 10, 10,  8, 6, 4,
         6, 8, 10, 12, 12, 10, 8, 6,
         6, 8, 10, 12, 12, 10, 8, 6,
         4, 6,  8, 10, 10,  8, 6, 4,
         2, 4,  6,  8,  8,  6, 4, 2,
         0, 2,  4,  6,  6,  4, 2, 0
      },
      { /* Black */
         0, 2,  4,  6,  6,  4, 2, 0,
         2, 4,  6,  8,  8,  6, 4, 2,
         4, 6,  8, 10, 10,  8, 6, 4,
         6, 8, 10, 12, 12, 10, 8, 6,
         6, 8, 10, 12, 12, 10, 8, 6,
         4, 6,  8, 10, 10,  8, 6, 4,
         2, 4,  6,  6,  6,  6, 4, 2,
         0, 2,  4,  6,  6,  4, 2, 0
      }
   },

   /*
    * Bishops
    */
   { /* White */
      {
         0, 2,  4,  6,  6,  4, 2, 0,
         2, 8,  6,  8,  8,  6, 8, 2,
         4, 6,  6,  6,  6,  6, 6, 4,
         6, 8, 10, 12, 12, 10, 8, 6,
         6, 8, 10, 12, 12, 10, 8, 6,
         4, 6,  8,  8,  8,  8, 6, 4,
         2, 6,  6,  8,  8,  6, 6, 2,
         0, 2,  4,  6,  6,  4, 2, 0
      },
      { /* Black */
         0, 2,  4,  6,  6,  4, 2, 0,
         2, 6,  6,  8,  8,  6, 6, 2,
         4, 6,  8,  8,  8,  8, 6, 4,
         6, 8, 10, 12, 12, 10, 8, 6,
         6, 8, 10, 12, 12, 10, 8, 6,
         4, 6,  6,  6,  6,  6, 6, 4,
         2, 8,  6,  8,  8,  6, 8, 2,
         0, 2,  4,  6,  6,  4, 2, 0
      }
   },

   /*
    * Rook
    */
   { /* White */
      {
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
        10,10,10,10,10,10,10,10,
         0, 0, 0, 5, 5, 0, 0, 0,
      },
      { /* Black */
         0, 0, 0, 5, 5, 0, 0, 0,
        10,10,10,10,10,10,10,10,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
         0, 0, 0, 5, 5, 0, 0, 0,
      }
   },

   /*
    * Queen
    */
   { /* White */
      {
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
      },
      { /* Black */
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
      }
   },

   /*
    * King
    */
#ifdef USE_KING_TABLES
   { /* White */
      {
         0,  0, 20,  0,  0,  0, 20,  0,
         -10,-10,-10,-10,-10,-10,-10,-10,
         -20,-20,-20,-20,-20,-20,-20,-20,
         -40,-40,-40,-40,-40,-40,-40,-40,
         -80,-80,-80,-80,-80,-80,-80,-80,
         -120,-120,-120,-120,-120,-120,-120,-120,
         -120,-120,-120,-120,-120,-120,-120,-120,
         -120,-120,-120,-120,-120,-120,-120,-120,
      },
      { /* Black */
         -120,-120,-120,-120,-120,-120,-120,-120,
         -120,-120,-120,-120,-120,-120,-120,-120,
         -120,-120,-120,-120,-120,-120,-120,-120,
         -80,-80,-80,-80,-80,-80,-80,-80,
         -40,-40,-40,-40,-40,-40,-40,-40,
         -20,-20,-20,-20,-20,-20,-20,-20,
         -10,-10,-10,-10,-10,-10,-10,-10,
         0,  0, 20,  0,  0,  0, 20,  0,
      }
   },
#else
   { /* White */
      {
         0,  0, 20,  0,  0,  0, 20,  0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
      },
      { /* Black */
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0,
         0,  0, 20,  0,  0,  0, 20,  0,
      }
   },
#endif

   /* King, end game */
   { /* White */
      {
         0, 2,  4,  6,  6,  4, 2, 0,
         2, 4,  6,  8,  8,  6, 4, 2,
         4, 6,  8, 10, 10,  8, 6, 4,
         6, 8, 10, 12, 12, 10, 8, 6,
         6, 8, 10, 12, 12, 10, 8, 6,
         4, 6,  8, 10, 10,  8, 6, 4,
         2, 4,  6,  8,  8,  6, 4, 2,
         0, 2,  4,  6,  6,  4, 2, 0
      },
      { /* Black */
         0, 2,  4,  6,  6,  4, 2, 0,
         2, 4,  6,  8,  8,  6, 4, 2,
         4, 6,  8, 10, 10,  8, 6, 4,
         6, 8, 10, 12, 12, 10, 8, 6,
         6, 8, 10, 12, 12, 10, 8, 6,
         4, 6,  8, 10, 10,  8, 6, 4,
         2, 4,  6,  8,  8,  6, 4, 2,
         0, 2,  4,  6,  6,  4, 2, 0
      }
   },
};

