#include "genrand.h"
#include "computer.h"
#include "board.h"
#include "movegen.h"
#include "game.h"
#include "inline/game.h"

void computer_play(gamestate_t *game, int max_depth)
{
   movelist_t movelist;
   int move_perm[MAX_MOVES];
   int me;
   int n;

   generate_moves(&movelist, game->board, game->player);

   for (n=0; n<movelist.num_moves; n++) {
      move_perm[n] = n;
   }

   /* Scramble move order; play a random move */
   for (n=0; n<movelist.num_moves; n++) {
      int m = n + genrandf() * (movelist.num_moves - n);
      int k = move_perm[n];
      move_perm[n] = move_perm[m];
      move_perm[m] = k;
   }

   me = game->player;
   for (n=0; n<movelist.num_moves; n++) {
      playmove(game, movelist.move[move_perm[n]]);
      if (!player_in_check(game, me)) {   /* We found a legal move! */
         break;
      }
      takeback(game);
   }

   return;
}
