#include "computer.h"
#include "alphabeta.h"
#include "genrand.h"
#include "board.h"
#include "movegen.h"
#include "game.h"
#include "inline/game.h"

void computer_play(gamestate_t *game, int max_depth)
{
   movelist_t movelist;
   int move_score[MAX_MOVES];
   int best_score;
   int best_move;
   int legal_moves;
   int depth;
   int me;
   int n;

   generate_moves(&movelist, game->board, game->player);
   best_move = 0;
   best_score = -3*CHECKMATE;

   me = game->player;
   legal_moves = movelist.num_moves;
   for (n=0; n<movelist.num_moves; n++) {
      playmove(game, movelist.move[n]);
      if (!player_in_check(game, me)) {   /* We found a legal move! */
         alphabeta_state_t state =
            alphabeta(game, max_depth, -CHECKMATE, CHECKMATE);
         state.score = -state.score;
         printf("    %s %g ",
               move_string(movelist.move[n], NULL), state.score/100.0);
         printf("(%s %g)\n",
               move_string(movelist.move[best_move], NULL), best_score/100.0);

         if (state.score > best_score) {
            best_move = n;
            best_score = state.score;
         }
      } else {
         legal_moves--;
      }
      takeback(game);
   }

   printf("--> %s %d %g\n", move_string(movelist.move[best_move], NULL),
                                                best_move, best_score/100.0);
   printf("%d %d\n", best_score, -2*CHECKMATE);
   if (legal_moves == 0)      /* Hmm... no legal moves? */
      return;

   playmove(game, movelist.move[best_move]);

   return;
}
