#ifndef PAWN_TABLE_H
#define PAWN_TABLE_H

typedef struct {
   uint64_t key;           /* Store the full key (for position verification) */
   int score;              /* The value of this node */

   /* Some data we may want or need */
#if 0
   bitboard_t duo[2];
   bitboard_t backward_pawns[2];
   bitboard_t isolated_pawns[2];
   bitboard_t connected_pawns[2];
   bitboard_t doubled_pawns[2];
   bitboard_t free_pawns[2];
   uint8_t pawn_files[2];
#endif
   uint8_t open_files;
   uint8_t half_open_files[2];

   /* Free pawns and connected free pawns
    * Stop squares are squares directly in front of the free pawn.
    */
   bitboard_t connected_free[2];
   bitboard_t free[2];

   /* Weak squares and outposts */
   bitboard_t outposts[2];
   bitboard_t strong_squares[2];
} pawn_structure_t;

typedef struct {
   pawn_structure_t *data;
   size_t number_of_elements;
} pawn_hash_table_t;

pawn_hash_table_t *create_pawn_hash_table(size_t nelem);
void destroy_pawn_hash_table(pawn_hash_table_t *table);
pawn_structure_t *query_pawn_table_entry(pawn_hash_table_t *table, uint64_t key);

#endif
