#ifndef MOVEGEN_H
#define MOVEGEN_H

#include <stdbool.h>
#include "move.h"
#include "board.h"

void generate_movement_tables(void);
void generate_moves(movelist_t *movelist, const board_t *board, int colour);
void generate_quiescence_moves(movelist_t *movelist, const board_t *board, int colour);


int validate_move(const movelist_t *movelist, int source, int dest);
bool square_is_attacked(const board_t *board, int square, int player);


bitboard_t get_attack_bitboard(const board_t *board, int side);
bitboard_t get_attackers(const board_t *board, int side, int square);
bitboard_t get_all_attackers(const board_t *board, int square);

#endif
