#ifndef HASHTABLE_H
#define HASHTABLE_H

#include <stdint.h>
#include "move.h"

/* Types of entries that may occur in the table (flags) */
#define HASH_TYPE_EXACT       0x00000001
#define HASH_TYPE_ALPHA       0x00000002
#define HASH_TYPE_BETA        0x00000004
#define HASH_TYPE_BOOK        0x00000008  /* Special - refer to opening book */

/* Entries in the hash table */
typedef struct {
   uint64_t key;           /* Store the full key (for position verification) */
   int depth;              /* The depth to which this position was searched */
   int score;              /* The value of this node */
   uint8_t flags;          /* Properties of this entry */
   uint8_t age;            /* Age of this entry */
   move_t best_move;       /* The best move returned from the previous search */
} hash_table_entry_t;

typedef struct {
   /* We keep two parallel hash tables: a "depth priority" table and an
    * "always replace" table.
    */
   hash_table_entry_t *data;
   hash_table_entry_t *depth_data;
   size_t number_of_elements;
} hash_table_t;

hash_table_t *create_hash_table(size_t nelem);
void destroy_hash_table(hash_table_t *table);
void store_table_entry(hash_table_t *table, uint64_t key, int depth,  int score, unsigned int flags, move_t best_move);
hash_table_entry_t *query_table_entry(hash_table_t *table, uint64_t key);

#endif
