#ifndef HANGING_H
#define HANGING_H

#include <stdint.h>

/* Structure holding information about attackers or defenders for a square.
 * This can be used to encode whether a piece on a certain square hangs:
 * this is the case if there are more attackers than defenders or the
 * lowest attacker has a smaller value than the piece itself.
 */
typedef union {
   uint8_t bits;
   struct {
      uint8_t number        : 3; /* Number of attackers, 8 max. */
      uint8_t pawn          : 1; /* At least one pawn attacks this square */
      uint8_t knight_bishop : 1; /* At least one knight or bishop */
      uint8_t rook          : 1; /* At least one rook */
      uint8_t queen         : 1; /* At least one queen */
      uint8_t king          : 1; /* At least one king */
   }
} square_attack_t;

#endif
