#ifndef EVALUATE_H
#define EVALUATE_H

#include "game.h"

/* When the evaluation function detects that there is less than this amount
 *  of material present, it will perform an endgame evaluation
 * The quiescence search will not perform a null move in these cases
 */
#define ENDGAME_MATERIAL   (4*500 + 10*100 + 2*300)

/* Bonus for having the bishop pair */
#define EVAL_BISHOP_PAIR      50

/* Bonus for an advanced duo (6th rank or beyond) */
#define EVAL_ADVANCED_DUO     400

extern int static_evaluation(gamestate_t *game, int player);

#endif
