#ifndef CONFIG_H
#define CONFIG_H

#define MAX_SEARCH_DEPTH 60       /* maximum depth of search tree */

#define HARD_HORIZON -20

#define MAX_TOTAL_DEPTH (MAX_SEARCH_DEPTH - HARD_HORIZON)

/* Number of entries in the hash table; one entry is 28 bytes */
#define HASH_TABLE_SIZE (1024*1024)    // ~30 MB

/* Number of entries in the pawn structure hash table */
#define PAWN_TABLE_SIZE (32*1024)

/* Check extensions: extend the search by one ply on check (the exact
 * conditions under which to extend the search can be tuned)
 */
#define CHECK_EXTENSION

/* Tune how the check extension works: extend all checks, or just repeated
 * check.
 */
#undef EXTEND_ALL_CHECKS

/* Pawn-push extension: extend the search by two ply if a pawn moves to the
 * seventh row.
 */
#define PAWN_PUSH_EXTENSION

/* Late move reductions. The idea is that moves that are low in the move
 * list are generally less interesting than moves that are higher up on the
 * list, and we don't need to spend as much time on them. If this buys us
 * some extra plies, we will detect whatever interesting moves there are
 * at that point anyway.
 */
#define LATE_MOVE_REDUCTION

/* Futility pruning: at the frontier nodes (horizon distance for the current
 * position == 2), if the static evaluation plus the gain of a minor piece
 * does not improve alpha, reduce the search depth.
 */
#define FUTILITY_PRUNING

/* "Delta pruning": the same idea as futility pruning, but during the
 * quiescence search.
 * Disabled, because it doesn't seem to improve anything.
 */
#undef USE_DELTA_PRUNING

/* Few moves extension: extend the search if the player only had a few
 * (2-3) leagl moves and we are one node away from the horizon - we may be
 * in danger of mate
 */
#define FEW_MOVES_EXTENSION

/* Recapture extensions: if the move is a recapture, then extend the search
 * by one ply.
 */
#define RECAPTURE_EXTENSION

/* Use three killer slots rather than two. The effect of this isn't very
 * clear: in a test position (the Fischer-Reshevski bishop sacrifice), the
 * code finds the winning move (Bxf7+!) after ~30 seconds using a 10 ply
 * search. Without it, it does the 10 ply search in ~20 seconds, but
 * doesn't find the winning move until the end of the 11 ply search in 75
 * seconds...
 *
 * Clearly more testing is needed here!
 */
#undef USE_THIRD_KILLER

/* "Mate killer": a killer move that produces a mate score. As the third
 * killer above, this doesn't really seem to do much...
 */
#define USE_MATE_KILLER

/* "Counter move": an extension to the killer idea, a killer move indexed
 * by the origin and destination for the previous move rather than by ply.
 * Doesn't seem to help much.
 * Should check what difference keeping two slots for this (as for killer
 * moves) makes.
 */
#define USE_COUNTER_MOVES

/* Use or don't use null-moves during the alpha-beta search */
#define ALLOW_NULL_MOVE

/* Use or don't use history heuristics - it helps in some cases and hurts
 * in others. It seems to work well in combination with late move
 * reductions, probably because it bumps "interesting" moves higher up in
 * the move ordering, eliminating much of the dangers of late move
 * reduction.
 *
 * DON'T USE!
 *
 * It seems to hurt more than it helps at larger search depths... this is
 * consistent with what has been found by (some) others.
 * One idea might be to use this during the initial phase of iterative
 * deepening (say, the first 6 plies) to get a better move ordering there,
 * and then disable it afterwards.
 * This makes sense: after 6 plies the position hasn't changed as much as
 * after 10 or 12 plies.
 * Tried that too - still doesn't help...
 */
#undef USE_HISTORY_HEURISTIC

/* Prune losing captures (as determined by SEE) during quiescence search.
 * This reduces the size of the search tree enormously.
 */
#define PRUNE_LOSING_CAPTURES

/* Use internal iterative deepening to find a "good move" if there is no
 * move from the hash table.
 */
#define USE_IID

#define USE_PVS
#undef USE_QS_PVS

/* Store PV in a tree structure at the root of the game tree, as opposed to
 * on the stack.
 * Doesn't seem to retrieve the full variation at the moment...
 */
#undef PRINCIPLE_VARIATION_IN_GAME_STRUCT

#endif
