#ifndef ALPHABETA_H
#define ALPHABETA_H

#include "game.h"

#define PLY 1

/* Struct so we can return the best score as well as the move that
 * generated it from alphabeta.
 */
typedef struct {
   int score;

   /* Search depth reached for this node */
   int depth;
   int qdepth;

   /* Return the principle variation - maybe should not do this on the
    * stack though!
    */
   move_t mainline[MAX_SEARCH_DEPTH];
   int size_of_variation;
} alphabeta_state_t;

extern volatile bool abort_search;
extern int positions_evaluated;
extern int moves_searched;
extern int positions_in_hashtable;
extern int branches_pruned;

alphabeta_state_t alphabeta(gamestate_t *game, int depth, int horizon_distance, int alpha, int beta, bool in_pv);

bool draw_by_repetition(gamestate_t *game);

#endif
