
#include <allegro.h>
#include <cmath>
/*
#include <iostream>
#include <fstream>
using std::endl;
using std::ofstream;
*/
#include "HueWheelRR.hpp"

volatile int ticks = 0;
const int bps = 30;
int ticker_rate = 0;
const int hue_drag_min_ticks = bps/4;// 15 = 1/4 second
void Ticker() {
  ++ticks;
}
END_OF_FUNCTION(Ticker);

//ofstream logfile("./HWmain_log.txt");

int main() {
  
//  if (!logfile) {return 0;}
  
  if (allegro_init() != 0) {return 0;}
  if (install_timer() != 0) {return 0;}
  if (install_keyboard() != 0) {return 0;}
  if (install_mouse() < 0) {return 0;}
  
  int dcd = desktop_color_depth();
  if (dcd == 0) {dcd = 32;}
  set_color_depth(dcd);
  int dw = 800 , dh = 600;
  int gfxmode = GFX_AUTODETECT_WINDOWED;
  
  if (set_gfx_mode(gfxmode , dw , dh , 0 , 0) != 0) {return 0;}
  
  BITMAP* buffer = create_bitmap(dw , dh);
  if (!buffer) {return 0;}
  
  clear_to_color(buffer , makecol(0,0,0));
  blit(buffer , screen , 0 , 0 , 0 , 0 , dw , dh);
  
  LOCK_VARIABLE(ticks);
  LOCK_FUNCTION(Ticker);
  
  const int hwir = dh/4 - 25;
  const int hwor = dh/4 + 25;// 175*2 + 3 = 353
  const int hwx = (dw - 353)/2;
  const int hwy = (dh - 353)/2;
  
  HueWheelRR huewheel(hwx,hwy,hwir,hwor);
  huewheel.SetDragDelay(bps/4);
//  huewheel.SetLog(logfile);
//  logfile.precision(5);
  
//  int corner_size = int((sqrt(2.0)*(double(huewheel.GetWidth())/2.0) - double(hwor))*0.9/sqrt(2.0));
  
  double hue = 280.0 , sat = 0.9 , val = 0.5;
  int r = 255 , g = 0 , b = 0;
  huewheel.SetHSV(hue , sat , val);
  huewheel.StoreRGB(&r , &g , &b);
  int hwcolor = huewheel.GetColor();
//  const double rad_to_deg = 180.0/M_PI;
//  const double deg_to_afix = 256.0/360.0;
  
  bool redraw = true;
  bool display = true;
  bool color_changed = false;
  const int SCALAR = 0;
  const int CLOSEST = 1;
  const int POSITION = 2;
//  const int toggle[3] = {SCALAR , CLOSEST , POSITION};
  bool show_toggle[3] = {false , false , false};
  int ToggleKey[3] = {KEY_S , KEY_C , KEY_P};
//  bool show_scalar = false , show_closest = false , show_position = false;
  volatile char oldkey[KEY_MAX];
  
  const int display_count_start = 255;
  int display_count = 0;
  
  // Mouse variables
  int mb = 0 , old_mb = 0;// Mouse button state tracking
  int mpos = 0 , mx = 0 , my = 0;// Mouse position
//  int cx = 0 , cy = 0;// Click position
//  int ox = 0 , oy = 0;// Offset position
//  int dsq = 0;// distance squared
//  double angle_rad = 0.0;
  
  double mpsat = -1.0 , mpval = -1.0;// values for saturation and value for the current position of the mouse pointer
  
  show_mouse(screen);
  
  
  ticker_rate = BPS_TO_TIMER(bps);
  int old_ticks = 0;
  int total_ticks = 0;
  install_int_ex(Ticker , ticker_rate);
  ticks = 1;
  
  while (!key[KEY_ESC]) {
    
    while(ticks == 0) {
      rest(1);
    }
    old_ticks = ticks;
    ticks = 0;
    total_ticks += old_ticks;
    
    // check input , process logic
    old_mb = mb;
    mb = mouse_b;
    mpos = mouse_pos;
    mx = mpos >> 16;
    my = mpos & 0x0000ffff;
    
    for (int i = 0 ; i < 3 ; ++i) {
      if (key[ToggleKey[i]] && !oldkey[ToggleKey[i]]) {
        show_toggle[i] = !show_toggle[i];
        redraw = true;
      }
    }
    color_changed = huewheel.HandleMouseInput(mx - hwx , my - hwy , mb);
    if (color_changed) {
      huewheel.StoreHSV(&hue , &sat , &val);
      huewheel.StoreRGB(&r , &g , &b);
      hwcolor = huewheel.GetColor();
      display_count = display_count_start;
      redraw = true;
    }
    
    for (int i = 0 ; i < 3 ; ++i) {
      if (show_toggle[i]) {redraw = true;}
    }
    
    for (int i = 0 ; i < KEY_MAX ; ++i) {
      oldkey[i] = key[i];
    }
    
    // draw output
    if (redraw) {
      clear_to_color(buffer , hwcolor);
      huewheel.Draw(buffer);
      
      if (show_toggle[SCALAR]) {
        huewheel.VisuallyFindSVfromMousePos(buffer , mx - hwx , my - hwy , mpsat , mpval);
        textprintf_ex(buffer , font , hwx      , 12 , makecol(255,255,255) , -1 , "FindSVfromMousePos :");
        textprintf_ex(buffer , font , hwx + 16 , 24 , makecol(255,255,255) , -1 , 
                      "Sat : %3.2f , Val : %3.2f" , mpsat , mpval);
      }
      if (show_toggle[CLOSEST]) {
        huewheel.VisuallyFindClosestSVfromMousePos(buffer , mx - hwx , my - hwy , mpsat , mpval);
        textprintf_ex(buffer , font , hwx      , 36 , makecol(255,255,255) , -1 , "FindClosestSVfromMousePos :");
        textprintf_ex(buffer , font , hwx + 16 , 48 , makecol(255,255,255) , -1 , 
                      "Sat : %3.2f , Val : %3.2f" , mpsat , mpval);
      }
      if (show_toggle[POSITION]) {
        huewheel.VisualizeIndicatorPos(buffer , makecol(255,255,0));
        huewheel.FindSVfromMousePos(mx - hwx , my - hwy , mpsat , mpval);
        huewheel.VisualizeIndicatorPos(buffer , mpsat , mpval , makecol(0,255,255));
      }
//      huewheel.VisualizeIndicatorPos(buffer , mpsat , mpval , makecol(0,255,255));
//      huewheel.StoreWH(&vwhx , &vwhy);
//      textprintf_ex(buffer , font , hwx , 12 , makecol(255,255,255) , -1 , 
//                    "V MPOS Sat : %3.2f , Val : %3.2f" , mpsat , mpval);
///      textprintf_ex(buffer , font , hwx , 24 , makecol(255,255,255) , -1 , 
///                    "VecWH x : %3.2f , y : %3.2f" , vwhx , vwhy);
      textprintf_ex(buffer , font , hwx      , 72 , makecol(255,255,255) , -1 , "Current Hue Wheel color values :");
      textprintf_ex(buffer , font , hwx + 16 , 84 , makecol(255,255,255) , -1 , 
                    "H : %3.2f , S : %3.2f , V : %3.2f" , hue , sat , val);
      textprintf_ex(buffer , font , hwx + 16 , 96 , makecol(255,255,255) , -1 , 
                    "R : %3d , G : %3d , B : %3d" , r , g , b);
      
      display = true;
      redraw = false;
    }
    
    // display
    if (display) {
      blit(buffer , screen , 0 , 0 , 0 , 0 , dw , dh);
      display = false;
    }
  }
  
  destroy_bitmap(buffer);
  return 0;
}
END_OF_MAIN()


/**
Notes :

Dot Product
----------------
The dot product of two vectors is the sum of the products of the corresponding components :
V1 = [5,12,13]
V2 = [3,4,5]
V1 dot V2 = (5*3) + (12*4) + (13*5) = 15 + 48 + 65 = 128

Cross Product
----------------
(From Wikipedia : http://en.wikipedia.org/wiki/Cross_Product )
The cross product is defined by the formula[2]

A x B = |a||b|sinθ*Normal?

\mathbf{a} \times \mathbf{b} = a b \sin \theta \ \mathbf{\hat{n}}

where θ is the measure of the smaller angle between a and b (0° ≤ θ ≤ 180°),
a and b are the magnitudes of vectors a and b,
and \mathbf{\hat{n}} is a unit vector perpendicular to the plane containing a and b.

If the vectors a and b are collinear (i.e., the angle θ between them is either 0° or 180°),
by the above formula, the cross product of a and b is the zero vector 0.

//*/



