
#ifndef HueWheelRR_H
#define HueWheelRR_H

#include <allegro.h>
#include <cmath>
#include <iostream>
#include <ostream>
using std::cout;
using std::endl;
using std::ostream;


/// Yahbu Mezam, japanese ceramic vase

class Pos2d {
public :
  int x,y;
  Pos2d() : x(0) , y(0) {}
  ~Pos2d() {}
  Pos2d(int xpos , int ypos) : x(xpos) , y(ypos) {}
  Pos2d(const Pos2d& p2d) : x(p2d.x) , y(p2d.y) {}
  Pos2d& operator=(const Pos2d& p2d) {
    x = p2d.x;
    y = p2d.y;
    return *this;
  }
};

void DrawArrow(BITMAP* bmp , int sx , int sy , int dx , int dy , int color);
inline void DrawArrow(BITMAP* bmp , double sx , double sy , double dx , double dy , int color) {
  DrawArrow(bmp , int(sx) , int(sy) , int(dx) , int(dy) , color);
}

/// The width and height of a HueWheelRR object will always be 2*outer_radius + 3 (always an odd number)

class HueWheelRR {
private:
  int tlx , tly , cx , cy;
  int midx , midy;
  int width , irad , orad;
  int indrad , indwidth;
  
  // vertices of the saturation value triangle Hue , White , Black , Midpoint of H & W
  struct V3D_f vH,vW,vB,vM;
  
  // useful vectors
  struct V3D_f vecHB,vecBW,vecWH;
  
  // For drawing outline underneath the saturation value triangle
  struct V3D_f vH_ol,vW_ol,vB_ol;
  
  // location of the SaturationValue Indicator
  int svix,sviy;
  
  // precalculated distances and angles
  double distHB,distBW,distWH,distBM,distMW;
  double angle_HB_rad , angle_BW_rad , angle_WH_rad;
  double angle_BM_rad , angle_MW_rad , angle_MB_rad;
  
  float h,s,v;
  int r,g,b,rgbcolor;
  
  double hue_angle_deg , old_hue_angle_deg , click_angle_deg;
  
  int old_mbtn;
  int drag_tick_count , drag_min_ticks;
  
  bool hue_click , hue_drag , sv_click , sv_drag;
  bool hue_changed , sv_changed;
  double NewHue,NewSaturation,NewValue;
  
  BITMAP* huewheel;
  BITMAP* hwbuffer;
  BITMAP* svtriangle;
  BITMAP* svindicator;
  BITMAP* buffer;
  
  Pos2d* hw_outline;
  int num_outline_pixels;
  
  ostream* oplog;
  
  bool ReAllocateBitmaps();
  void FreeBitmaps();
  
  void InitializeVertices();
  void ResetVerticePositions();
  void ResetVerticeColors();
  void ResetVertices();
  void ResetIndicatorPos();
  
  bool DrawStartingHueWheel();
  void DrawStartingSatValTriangle();
  void DrawSVIndicator();
  
  void DrawHueWheel();
  void DrawSatValTriangle();
  void DrawHueWheelBuffer();
  
  void UpdateBuffer();

  ostream& Log() {
    if (oplog) {return *oplog;}
    return cout;
  }

public :
  HueWheelRR(int xpos , int ypos , int inner_radius , int outer_radius , int indicator_radius = 5);
  ~HueWheelRR();
  
  /// Will be transparently drawn at tlx and tly on the destination bitmap - these are the same as 
  ///   the values passed in the constructor for xpos and ypos
  void Draw(BITMAP* dest);
  
  /// HandleMouseInput returns true if the hue/saturation/value changed and false if it did not
  bool HandleMouseInput(const int mx , const int my , int mbtn);
  
  /// FindSVfromMousePos() returns true if either the saturation or value of the coordinate is different from
  ///   the stored values for saturation and value and stores those values in the 3rd and 4th parameters.
  /// Pass only mouse values relative to tlx and tly (real_mx - tlx , real_my - tly , ,) - ie. position on dest bitmap
  inline bool FindClosestSVfromMousePos(int mx , int my , double& saturation , double& value) {
    return FindClosestSVfromMousePos(double(mx) , double(my) , saturation , value);
  }
  bool FindClosestSVfromMousePos(const double mx , const double my , double& saturation , double& value);

  inline bool FindSVfromMousePos(int mx , int my , double& saturation , double& value) {
    return FindSVfromMousePos(double(mx) , double(my) , saturation , value);
  }
  bool FindSVfromMousePos(double mx , double my , double& saturation , double& value);

  void VisuallyFindClosestSVfromMousePos(BITMAP* dest , double mx , double my , double& saturation , double& value);
  bool VisuallyFindSVfromMousePos(BITMAP* dest , int mx , int my , double& saturation , double& value);
  void VisualizeIndicatorPos(BITMAP* dest , int color);
  void VisualizeIndicatorPos(BITMAP* dest , double sat , double val , int color);

  void SetHSV(double hue , double sat , double val);
  void SetRGB(int red , int green , int blue);
  void SetDragDelay(int ticks);

  void StoreHSV(double* hue , double* sat , double* val);
  void StoreRGB(int* red , int* green , int* blue);
  int GetWidth();
  int GetHeight();
  void StoreWH(float* whx , float* why) {
    if (whx) {*whx = vecWH.x;}
    if (why) {*why = vecWH.y;}
  }
  int GetColor() {return rgbcolor;}

  void SetLog(ostream& os) {
    oplog = &os;
  }
};

#endif

