
#include <allegro.h>
#include <cmath>

volatile int ticks = 0;
const int bps = 60;
int ticker_rate = 0;
const int hue_drag_min_ticks = bps/4;// 15 = 1/4 second
void Ticker() {
  ++ticks;
}
END_OF_FUNCTION(Ticker);


void DrawHueWheel(BITMAP* bmp , int xpos , int ypos , int inner_radius , int outer_radius);

void DrawSatValTriangle(BITMAP* bmp , int xpos , int ypos , int radius , double hue);

int main() {
  
  if (allegro_init() != 0) {return 0;}
  if (install_timer() != 0) {return 0;}
  if (install_keyboard() != 0) {return 0;}
  if (install_mouse() < 0) {return 0;}
  
  int dcd = desktop_color_depth();
  if (dcd == 0) {dcd = 32;}
  set_color_depth(dcd);
  int dw = 800 , dh = 600;
  int gfxmode = GFX_AUTODETECT_WINDOWED;
  
  if (set_gfx_mode(gfxmode , dw , dh , 0 , 0) != 0) {return 0;}
  
  BITMAP* buffer = create_bitmap(dw , dh);
  if (!buffer) {return 0;}
  
  clear_to_color(buffer , makecol(0,0,0));
  blit(buffer , screen , 0 , 0 , 0 , 0 , dw , dh);
  
  LOCK_VARIABLE(ticks);
  LOCK_FUNCTION(Ticker);
  
  const int hwx = (2*dw)/3;
  const int hwy = dh/3;
  const int hwir = dh/4 - 25;
  const int hwor = dh/4 + 25;
  BITMAP* huewheel = create_bitmap(2*(hwor + 1) , 2*(hwor + 1));
  BITMAP* svtriangle = create_bitmap(huewheel->w , huewheel->h);
  if (!huewheel || !svtriangle) {return 0;}
  
//  clear_to_color(huewheel , makecol(255,0,255));
  DrawHueWheel(huewheel , huewheel->w/2 , huewheel->h/2 , hwir , hwor);
//  DrawSatValTriangle(buffer , huewheel->w/2 , huewheel->h/2 , hwir - 2 , hue);
  
  double hue = 0.0 , sat = 1.0 , val = 1.0;
  int r = 0 , g = 0 , b = 0;
  const double rad_to_deg = 180.0/M_PI;
  const double deg_to_afix = 256.0/360.0;
  double angle_deg = 0.0;
  double hue_angle_deg = 0.0;
  double old_hue_angle_deg = 0.0;
  double click_angle_deg = 0.0;
  double drag_angle_deg = 0.0;
  double delta_angle_deg = 0.0;
  
  bool hue_click = false;
  bool hue_drag = false;
  bool hue_changed = true;
  int hue_drag_tick_count = 0;
  bool redraw = true;
  bool display = true;
  
  
  // Mouse variables
  int mb = 0 , old_mb = 0;// Mouse button state tracking
  int mpos = 0 , mx = 0 , my = 0;// Mouse position
  int cx = 0 , cy = 0;// Click position
  int ox = 0 , oy = 0;// Offset position
  int dsq = 0;// distance squared
  double angle_rad = 0.0;
  
  show_mouse(screen);
  
  
  ticker_rate = BPS_TO_TIMER(bps);
  int old_ticks = 0;
  int total_ticks = 0;
  install_int_ex(Ticker , ticker_rate);
  ticks = 1;
  
  while (!key[KEY_ESC]) {
    
    while(ticks == 0) {
      rest(1);
    }
    old_ticks = ticks;
    ticks = 0;
    total_ticks += old_ticks;
    
    // check input , process logic
    old_mb = mb;
    mb = mouse_b;
    mpos = mouse_pos;
    mx = mpos >> 16;
    my = mpos & 0x0000ffff;
    
    if (hue_click) {
      if (mb & 1) {
        hue_drag = true;
        hue_drag_tick_count = 0;
      }
    }
    if (hue_drag) {
      if (mb & 1) {
        // still held down
        hue_drag_tick_count++;
      } else {
        // released
        hue_drag = false;
        if (hue_drag_tick_count < hue_drag_min_ticks) {
          hue_angle_deg -= click_angle_deg;
          if (hue_angle_deg < 0.0) {hue_angle_deg += 360.0;}
          hue = 360.0 - hue_angle_deg;
          hue_changed = true;
        }
        hue_drag_tick_count = 0;
        old_hue_angle_deg = hue_angle_deg;
      }
      if (hue_drag_tick_count >= hue_drag_min_ticks) {
        // find the relative amount that the rotation has changed by
        ox = mx - hwx;
        oy = my - hwy;
        angle_rad = atan2(oy,ox);
        drag_angle_deg = angle_rad*rad_to_deg;
        if (drag_angle_deg < 0.0) {drag_angle_deg += 360.0;}
        delta_angle_deg = drag_angle_deg - click_angle_deg;
        if (delta_angle_deg < 0.0) {delta_angle_deg += 360.0;}
        hue_angle_deg = old_hue_angle_deg + delta_angle_deg;
        if (hue_angle_deg >= 360.0) {hue_angle_deg -= 360.0;}
        hue = 360.0 - hue_angle_deg;
        hue_changed = true;
      }
    }
    
    if ((mb & 1) && !(old_mb & 1)) {// New mouse click with left mouse button
      ox = mx - hwx;
      oy = my - hwy;
      dsq = ox*ox + oy*oy;
      if ((dsq >= hwir*hwir) && (dsq <= hwor*hwor)) {// new click within hue wheel
        hue_click = true;
        angle_rad = atan2(oy , ox);
        angle_deg = angle_rad*rad_to_deg;
        if (angle_deg < 0.0) {angle_deg += 360.0;}
        click_angle_deg = angle_deg;
      } else {
        hue_click = false;
      }
    } else {
      hue_click = false;
    }
    
    if (hue_changed) {
      DrawSatValTriangle(svtriangle , svtriangle->w/2 , svtriangle->h/2 , hwir - 10 , hue);
      hue_changed = false;
      redraw = true;
    }
    
    // draw output
    if (redraw) {
      rotate_sprite(buffer , huewheel , hwx - huewheel->w/2 , hwy - huewheel->h/2 , ftofix(hue_angle_deg*deg_to_afix));
      draw_sprite(buffer , svtriangle , hwx - svtriangle->w/2 , hwy - svtriangle->h/2);
      textprintf_right_ex(buffer , font , SCREEN_W - 12 , SCREEN_H - 12 , makecol(255,255,255) , makecol(0,0,0) , "Ticks : %i" , total_ticks);
      display = true;
      redraw = false;
    }
    
    // display
    if (display) {
      blit(buffer , screen , 0 , 0 , 0 , 0 , dw , dh);
      clear_to_color(buffer , makecol(0,0,0));
      display = false;
    }
  }
  
  destroy_bitmap(huewheel);
  destroy_bitmap(svtriangle);
  destroy_bitmap(buffer);
  return 0;
}
END_OF_MAIN()


void DrawHueWheel(BITMAP* bmp , int xpos , int ypos , int inner_radius , int outer_radius) {
  if (inner_radius > outer_radius) {
    int temp = inner_radius;inner_radius = outer_radius;outer_radius = temp;
  }
  if (!bmp || (inner_radius < 0) || (outer_radius < 1)) {return;}
  
  BITMAP* mask = create_bitmap(bmp->w , bmp->h);
  const int maskcolor = makecol(0,0,0);
  clear_to_color(mask , maskcolor);
  circlefill(mask , xpos , ypos , outer_radius , bitmap_mask_color(mask));
  circlefill(mask , xpos , ypos , inner_radius - 1 , maskcolor);
  
  int rx = 0, ry = 0;
  
  double arad = 0.0;
  const double rad_to_deg = 180.0/M_PI;
  
  double h = 0.0 , s = 1.0 , v = 1.0;
  int r = 0 , g = 0 , b = 0;
  int color = 0;
  
  clear_to_color(bmp , bitmap_mask_color(bmp));
  for (int y = 0 ; y < mask->h ; ++y) {
    for (int x = 0 ; x < mask->w ; ++x) {
      if (getpixel(mask , x , y) != maskcolor) {
        rx = x - xpos;
        ry = y - ypos;
        arad = atan2(ry , rx);
        h = arad*rad_to_deg;
        if (h < 0.0) (h += 360.0);
        hsv_to_rgb(h,s,v,&r,&g,&b);
        /// Fudge the colors so this bitmap will work with draw_sprite
        if ((r == 255) && (g == 0) && (b == 255)) {
          r = 254;
          b = 254;
        }
        color = makecol(r,g,b);
        putpixel(bmp , x , y , color);
      }
    }
  }
}


void DrawSatValTriangle(BITMAP* bmp , int xpos , int ypos , int radius , double hue) {
  static const double sine2pi_over_3 = sin((2.0*M_PI)/3.0);
  static const double cos2pi_over_3 = cos((2.0*M_PI)/3.0);
  
  const double xoffset = radius*cos2pi_over_3;
  const double yoffset = radius*sine2pi_over_3;
  
  int r = 0 , g = 0 , b = 0;
  hsv_to_rgb(hue , 1.0 , 1.0 , &r , &g , &b);
  /// Fudge for making draw_sprite work when the hue produces magic pink
  if ((r == 255) && (g == 0) && (b == 255)) {
    r = 254;
    b = 254;
  }
  
  V3D_f rt = {
    xpos + radius , ypos , 0 , 0 , 0 , makecol(r,g,b)
  };
//  hsv_to_rgb(hue , 1.0 , 1.0 , &r , &g , &b);
  V3D_f ul = {
    xpos + xoffset , ypos + yoffset , 0 , 0 , 0 , makecol(0,0,0)
  };
//  hsv_to_rgb(hue , 1.0 , 1.0 , &r , &g , &b);
  V3D_f ll = {
    xpos + xoffset , ypos - yoffset , 0 , 0 , 0 , makecol(255,255,255)
  };
  
  int outline_color = makecol(127,127,127);
  V3D_f bg_right = {
    rt.x + 2 , rt.y , 0 , 0 , 0 , outline_color
  };
  V3D_f bg_upperleft = {
    ul.x - 2 , ul.y + 3 , 0 , 0 , 0 , outline_color
  };
  V3D_f bg_lowerleft = {
    ll.x - 2 , ll.y - 3 , 0 , 0 , 0 , outline_color
  };
  
  
  clear_to_color(bmp , bitmap_mask_color(bmp));
//void triangle3d_f(BITMAP *bmp, int type, BITMAP *tex, V3D_f *v1, *v2, *v3);
  triangle3d_f(bmp , POLYTYPE_GCOL , NULL , &bg_right , &bg_upperleft , &bg_lowerleft);
  triangle3d_f(bmp , POLYTYPE_GCOL , NULL , &rt , &ul , &ll);
}


