#include <string>
#include <iostream>
#include <fstream>
using namespace std;

#include "globals.h"

bool StringIsInArray(string str, const char* array[]) {
	for (int i = 0; array[i]; ++i)
		if (str == array[i])
			return true;
	return false;
}

bool StringIsOperator(string str) {
	return StringIsInArray(str, CppOperators);
}

bool EndsWith(string haystack, string needle)
{
	if (needle.length() > haystack.length())
		return false;
	return haystack.substr(haystack.length() - needle.length(), needle.length()) == needle;
}

bool StartsWith(string haystack, string needle)
{
	if (needle.length() > haystack.length())
		return false;
	return haystack.substr(0, needle.length()) == needle;
}

bool StringStartsComment(string str)
{
	return StartsWith(str, "//") || StartsWith(str, "/*");
}

bool Contains(string haystack, char needle)
{
	for (unsigned i = 0; i < haystack.length(); ++i)
		if (haystack[i] == needle)
			return true;
	return false;
}

string ReadFile(const char* filename) {
	string txt;
	fstream fin(filename);
	
	while (!fin.eof()) {
		char c = fin.get();
		if ((c > 32) || (c == '\n')) // filter out all non-linebreak whitespace
			txt += c;
		else
			txt += 32;
	}
	
	return txt;
}
