#ifndef PARSER_H
#define PARSER_H

#include <vector>
#include <string>
using namespace std;

#include "token.h"

class Parser {
	protected:
		vector<Token> tokens;
		vector<string> identifiers;
		unsigned NextIdentIndex;
	
		void Tokenize(string str);
		bool IsUnneccessaryToken(unsigned pos) const;
		void RemoveUnnecessaryTokens();
		void CollectIdentifiers();
		string GetNextUsableIdentifier();
		void ReplaceUserIdentifiers();
	
	public:
		Parser():NextIdentIndex(0) {}
		~Parser() {}
		
		void Read(string filename);
		void WriteCondensed() const;
};

#endif
