#include <vector>
#include <map>
#include <string>
#include <iostream>
#include <fstream>
#include <algorithm>

#include "exception.h"
#include "charutils.h"
#include "stringutils.h"
#include "globals.h"
#include "token.h"
#include "parser.h"

using namespace std;

int main(int argc, const char* argv[]) {
	const char* infilename = "";
	const char* IdentifiersFilename = 0;
	
	for (int a = 1; a < argc; ++a) {
		switch (argv[a][0]) {
			case '-':
				switch (argv[a][1]) {
					case 'i':
						++a;
						if (a < argc)
							IdentifiersFilename = argv[a];
						break;
				}
				break;
			default:
				infilename = argv[a];
		}
	}
	
	try	{
		Parser parser;
		parser.Read(infilename);
		parser.WriteCondensed();
	}
	catch (Exception ex) {
		cerr << ex.Message;
	}
	
	
	return 0;
}
