#ifndef __RETROHACK_H
#define __RETROHACK_H

#include <allegro.h>

#ifdef __cplusplus
extern "C" {
#endif
 
#define	AY_REGSELECT	0xfffd
#define AY_REGVALUE		0xbffd

#ifdef ALLEGRO_VERSION
typedef unsigned char Uint8;
typedef signed char Sint8;
typedef signed short Sint16;
typedef unsigned short Uint16;
typedef unsigned int Uint32;
typedef signed int Sint32;
#endif

#define RETROHACK_VERSION_MAJOR	1
#define	RETROHACK_VERSION_MINOR	1

extern void ay_Write(Uint16 Addr, Uint8 Value8);
extern Uint8 ay_Read(void);

extern int rt_Init(void);
extern void rt_Exit(void);

extern void rt_WaitCycles(int cycles);
#define RT_HSYNC	0
#define RT_VSYNC	1
extern void rt_WaitEvent(int event);

extern void rt_Flip();

enum rt_TargetFormats
{
	RT_Y, RT_CbCr, RT_MIX
};

extern void rt_FreeGraphic(void *graphic);
extern void *rt_UploadGraphic(enum rt_TargetFormats format, unsigned char *data, int pixelsperbyte, int width, int height, int maskcol);
extern void rt_Blit(void *graphic, int highnibble, int x, int y, int scalex, int scaley, int skew, int scalechange);
extern void rt_MaskedBlit(void *graphic, int highnibble, int x, int y, int scalex, int scaley, int skew, int scalechange);

extern Uint8 rt_ReadKeyboard(int addr);

extern int rtSim_QuitWanted(void);
extern void rtSim_SetWindowTitle(const char *name);

extern int psg_OpenFile(const char *name, int loop);
extern void psg_CloseFile(void);
extern int psg_Update(void);

#ifdef __cplusplus
}
#endif

#endif
