import wave

#########################################################

class Error(StandardError):
	def __init__(self, msg):
		StandardError.__init__(self, msg)

#########################################################

def onebyte_frame_value(byte):
	bval = ord(byte[0])
	return (bval / 255.0)

def twobyte_frame_value(bytes):
	bval = ord(byte[0]) * 256 + ord(byte[1])
	if (bval > 32767):
		bval -= 32768
	else:
		bval += 32768
	return (bval / 65535.0)

def convert_sample(wave_read, out):
	wav_freq = wave_read.getframerate()
	wav_len  = wave_read.getnframes()
	
	if (wave_read.getnchannels() != 1):
		raise Error("Stereo WAV files are not supported. Please convert to mono.")
	
	if (wave_read.getsampwidth() == 2):
		value_func = twobyte_frame_value
	else:
		value_func = onebyte_frame_value
		
	current_pos = 0.0
	current_frame = -1
	freq_ratio = (wav_freq / 8000.0)
	
	converted = []
	
	while (current_pos < wav_len):
		while (current_frame < int(current_pos)):
			current_frame += 1
			frame_bytes = wave_read.readframes(1)
		
		frame_val = value_func(frame_bytes)
		converted += [int(frame_val * 15.0 + 0.495)]
		
		current_pos += freq_ratio
	
	if (len(converted) % 2):
		converted += [converted[-1]]
	
	len_upper = int(len(converted) / 256)
	len_lower = len(converted) % 256
	out.write(chr(len_upper) + chr(len_lower))
	
	for pos in xrange(0, len(converted), 2):
		byte = converted[pos] * 16 + converted[pos+1]
		out.write(chr(byte))

##########################################################