#ifndef SOUNDPARTS_H
#define SOUNDPARTS_H

/****************************************/

#include "../Common.h"
#include <vector>

/****************************************/

enum SoundPartType {SP_PRE, SP_WAVE, SP_POST};

class SoundPart
{
	private:
		
	public:
		virtual SoundPartType type() = 0;
		virtual ~SoundPart() {};
		
		static SoundPart *loadPart(FILE *file);
		static std::vector<double> readDoubles(FILE *file, int count = -1);
};

class SoundPre : public SoundPart
{
	public:
		SoundPartType type() { return SP_PRE; };
		
		virtual double freq(double baseFreq, int frame) = 0;
		virtual double time(int frame) = 0;
		
		virtual ~SoundPre() {};
};

class SoundWave : public SoundPart
{
	public:
		SoundPartType type() { return SP_WAVE; };
		
		virtual double	level(double frequency, double time) = 0;
		virtual bool	soundDead(double frequency, double time) = 0;
		
		virtual ~SoundWave() {};
};

class SoundPost : public SoundPart
{
	public:
		SoundPartType type() { return SP_POST; };
		
		virtual double	actualLevel(double inputLevel, double time) = 0;
		virtual bool	soundDead(double time) = 0;
		
		virtual ~SoundPost() {};
};

/****************************************/

#endif
