#include <cstdlib>
#include "SoundBlocks.h"
#include "SoundParts.h"
#include "Digitized.h"

/*************************************************/

SoundPart *SoundPart::loadPart(FILE *f)
{
	char partType = (char)fgetc(f);
	
	std::vector<double> params;
	
	switch(partType)
	{
		case 'S':
			params = readDoubles(f, 2);
			return new Sine(params);
			
		case 'P':
			params = readDoubles(f, 2);
			return new Pulse(params);
			
		case 'N':
			params = readDoubles(f, 2);
			return new Noise(params);
			
		case 'E':
			params = readDoubles(f);
			return new Envelope(params);
			
		case 'D':
			int baseNote = fgetc(f);
			int len = fgetc(f) * 256 + fgetc(f);
			unsigned char *buffer = new unsigned char[len / 2];
			char *frameData = new char[len];
			
			fread(buffer, len / 2, 1, f);
			for (int i = 0; i < len / 2; i++)
			{
				frameData[i * 2] = (buffer[i] & 0xF0) >> 4;
				frameData[i*2+1] = buffer[i] & 0xF;
			}
			delete[] buffer;
			return new Digitized(baseNote, len, frameData);
			
		case 'V':
			params = readDoubles(f, 1);
			return new Volume(params);
			
		default:
			return NULL;
	}
};

/*************************************************/

std::vector<double> SoundPart::readDoubles(FILE *f, int count)
{
	std::vector<double> ret;
	
	for (int i = 0; i != count; i++)
	{
		int highByte = fgetc(f);
		int lowByte = fgetc(f);
		
		if ((highByte == 0xFF) && (lowByte == 0xFF))
			break;
			
		double decoded = highByte * 0.25 + lowByte * (0.25 / 256);
		ret.push_back(decoded);		
	}
	
	return ret;
}
