#ifndef SOUNDBLOCKS_H
#define SOUNDBLOCKS_H

/***********************************/

#include "SoundParts.h"
#include <vector>

/***********************************/

class Wave : public SoundWave
{
	protected:
		double freqMultiplier, amplification;
		
	public:
		Wave(std::vector<double> &param);
		
		bool	soundDead(double freq, double time) {return false;};
};

/***********************************/

class Sine : public Wave
{
	public:
		Sine(std::vector<double> &param) : Wave(param) {};
		double level(double frequency, double time);
};

/***********************************/

class Pulse : public Wave
{
	public:
		Pulse(std::vector<double> &param) : Wave(param) {};
		double level(double frequency, double time);
};

/***********************************/

class Noise : public Wave
{
	private:
		int state;
		double lastTime;
		
		double	nextRandom();
		
	public:
		Noise(std::vector<double> &param);
		double level(double frequency, double time);
};


/***********************************/

class Envelope : public SoundPost
{
	struct Transition{
		double duration;
		double target;
	};
	
	private:
		std::vector<Transition>		transitions;
		double						totalTime;
		
	public:
		Envelope();
		Envelope(std::vector<double> &param);
		
		void		addTransition(double duration, double target);
		
		bool		soundDead(double time);
		double		actualLevel(double inputLevel, double time);
};

/***********************************/

class Volume : public SoundPost
{
	private:
		double volumeMult;
		
	public:
	Volume(std::vector<double> &param) {volumeMult = param[0];};
	
	bool		soundDead(double time) {return volumeMult <= 0.01;};
	double		actualLevel(double inputLevel, double time) {return volumeMult * inputLevel;};
};

/***********************************/

#endif
