#ifndef SOUND_H
#define SOUND_H

/*************************************************/

#include "../Common.h"
#include <vector>
using namespace std;

/*************************************************/

class Sound
{
	private:
		double					baseFreq;
		
		SoundPre*				effectPre;
		std::vector<SoundWave*>	sndWaves;
		SoundPost*				sndPost;
		SoundPost*				effectPost;
		
	public:
		Sound(double baseFreq);
		~Sound();
		
		void		setEffectPre(SoundPre *pre) {effectPre = pre;};
		void		addWave(SoundWave *wave) {sndWaves.push_back(wave);};
		void		setPost(SoundPost *post, bool effect) {(effect ? effectPost : sndPost) = post;};
		
		bool		processFrame(Channel *channel, int frame);
};

/*************************************************/

#endif
