#include <iostream>
#include <cmath>

#include "Sound.h"
#include "SoundParts.h"
#include "Channel.h"

/*****************************************/

const double DAC_LEVELS[] = {
	0.00, 0.01, 0.02, 0.03, 0.04, 0.06, 0.08, 0.14, 
	0.17, 0.26, 0.35, 0.45, 0.57, 0.69, 0.85, 1.00
};

/*****************************************/

Sound::Sound(double baseFreq)
	: baseFreq(baseFreq)
{
	effectPre = NULL;
	sndPost = effectPost = NULL;
}

/*****************************************/

Sound::~Sound()
{
}

/*****************************************/

bool Sound::processFrame(Channel *channel, int frame)
{
	// pre
	double freq = baseFreq;
	double time = (frame / 15500.0);
	if (effectPre)
	{
		freq = effectPre->freq(baseFreq, frame);
		time = effectPre->time(frame);
	}
	
	// waves
	double levelTotal = 0.0;
	FOREACH(SoundWave*, it, sndWaves)
		levelTotal += (*it)->level(freq, time);
	
	// posts
	bool dead = false;
	if (sndPost)
	{
		levelTotal = sndPost->actualLevel(levelTotal, time);
		dead |= sndPost->soundDead(time);
	}
	if (effectPost)
	{
		levelTotal = effectPost->actualLevel(levelTotal, time);
		dead |= effectPost->soundDead(time);
	}
	levelTotal = levelTotal * 0.5 + 0.5;
	
	// calculating the level for DAC
	int dacLevel = (int)(levelTotal * 15.0);
	double prevDistance = 2.00;
	
	for (int i = 0; i < 16; i++)
	{
		double curDistance = std::abs(DAC_LEVELS[i] - levelTotal);
		if (curDistance < prevDistance)
		{
			prevDistance = curDistance;
			dacLevel = i;
		}
	}
	channel->volume(dacLevel);
	
	return dead;
}
