#ifndef SET_H
#define SET_H

/***********************************************/

#include "../Common.h"
#include <vector>

/***********************************************/

class Set
{
	private:
		struct Position
		{
			int			note;
			int			sample;
			SoundPart*	effect;
		};
		
		Module*					module;
		std::vector<Position>	channels[3];
		
		int tickCount;
		int tempo;
		int position;		
				
	public:
		Set(Module* mod);
		~Set();
		
		void	loadFromFile(FILE *f);
		
		void	rewind() {position = -1; tickCount = 0;};
		bool	tick(AY *ay, int soundPriority);
};

/***********************************************/

#endif
