#include <cstdio>
#include <cmath>
#include <iostream>

#include "Module.h"
#include "Set.h"
#include "Sample.h"
#include "AY.h"
#include "Channel.h"
#include "SoundParts.h"
#include "Sound.h"

/*****************************************/

Set::Set(Module *mod)
	: module(mod)
{
	rewind();
}

/*****************************************/

Set::~Set()
{
	for (int chan = 0; chan < 3; chan++)
		FOREACH(Position, it, channels[chan])
			if (it->effect)
				delete it->effect;
}

/*****************************************/

void Set::loadFromFile(FILE *f)
{
	int lastSample[3];
	
	tempo = (fgetc(f) << 8) + fgetc(f);
	
	while(true)
	{
		int next = fgetc(f);		
		if (next == 253)
			break;
		ungetc(next, f);
		
		for(int chan = 0; chan < 3; chan++)
		{
			int note = fgetc(f);
			if (note == 255)
			{
				Position p = {0, 0, NULL};
				channels[chan].push_back(p);
				continue;
			}
			
			int sample = fgetc(f);
			if (note == 254)
			{
				note = 0;
				sample = 0;
			}
			else
			{
				if (sample == 0)
					sample = lastSample[chan];
				lastSample[chan] = sample;
			}
			
			SoundPart *effect = SoundPart::loadPart(f);
			
			Position p = {note, sample, effect};
			channels[chan].push_back(p);
		}
	}	
}

/*****************************************/

bool Set::tick(AY *ay, int soundPriority)
{
	if (!(tickCount % tempo))
	{
		position++;
		if (position >= channels[0].size())
			return true;
			
		for (int i = 0; i < 3; i++)
		{
			Position p = channels[i][position];
			if (p.note)
			{
				double freq = 440.0 * std::pow(2.0, (p.note - 69.0) / 12.0);
				Sound *snd = module->sample(p.sample)->createSound(freq);
				ay->getChannel(i)->playSound(snd, soundPriority);
			}
			if (p.effect)
			{
				if (p.effect->type() == SP_POST)
					ay->getChannel(i)->getSound()->setPost((SoundPost*)p.effect, true);
				else if (p.effect->type() == SP_PRE)
					ay->getChannel(i)->getSound()->setEffectPre((SoundPre*)p.effect);
			}
		}
	}
	
	tickCount++;
	return false;
}
