#include <iostream>
#include "Sample.h"
#include "Sound.h"
#include "SoundParts.h"
#include "SoundBlocks.h"

/***********************************/

void Sample::loadFromFile(FILE *f)
{
	while (true)
	{
		SoundPart *sPart = SoundPart::loadPart(f);
		if (!sPart)
			break;
		else
			addPart(sPart);
	}
}

/***********************************/

Sample::~Sample()
{
	FOREACH(SoundPart*, it, soundParts)
		delete (*it);
}

/***********************************/

void Sample::addPart(SoundPart *part)
{
	soundParts.push_back(part);
}

/***********************************/

Sound *Sample::createSound(double frequency)
{
	Sound *snd = new Sound(frequency);

	for(std::vector<SoundPart*>::iterator it = soundParts.begin(); it != soundParts.end(); it++)
	{
		switch((*it)->type())
		{
			case SP_PRE:
				snd->setEffectPre((SoundPre*)(*it));
				break;
			case SP_WAVE:
				snd->addWave((SoundWave*)(*it));
				break;
			case SP_POST:
				snd->setPost((SoundPost*)(*it), false);
				break;
		}
	}
	
	return snd;
}
