#ifndef MODULE_H
#define MODULE_H

/*************************************/

#include <cstdio>
#include <vector>
#include "../Common.h"

/*************************************/

enum {
	PLAYBACK_NOTHING = 0,
	PLAYBACK_SET_END = 2,
	PLAYBACK_MODULE_END = 3
};

/*************************************/

class Module
{
	private:
		std::vector<Sample*> samples;
		std::vector<Set*> sets;
		std::vector<Set*> orders;
		
		int currentOrder;
		int currentPriority;
		
	public:
		Module(FILE *file);
		~Module();
		
		int			priority()			{return currentPriority;};
		void		priority(int pri)	{currentPriority = pri;};
		
		Sample*		sample(int no)	{return samples[no];};
		int			sampleCount()	{return samples.size();};
		
		Set*		set(int no)		{return sets[no];};
		int			setCount()		{return sets.size();};
		
		void	rewind() {currentOrder = -1;};
		void	rewindSet();
		
		Set*	playingSet();
		int		playingOrder();
		
		void	jumpToOrder(int order);
		int		orderCount() {return orders.size();};
		
		int		playFrame(AY *ay);
};

/*************************************/

#endif
