#include <iostream>
#include <cstdio>
#include <cstring>

#include "Module.h"
#include "Sample.h"
#include "Set.h"

/*****************************************/

Module::Module(FILE *f)
{
	samples.push_back(NULL);
	sets.push_back(NULL);
	
	char buf[5];
	fread(buf, 1, 4, f);
	buf[4] = 0;
	if (std::strcmp(buf, "SMoD") != 0)
		throw "Wrong header for a module file.";
	
	// read samples
	while (fgetc(f) != 0)
	{
		Sample *s = new Sample();
		s->loadFromFile(f);
		samples.push_back(s);
	}
	
	// read sets
	while (fgetc(f) != 0)
	{
		Set *s = new Set(this);
		s->loadFromFile(f);
		sets.push_back(s);
	}
	
	// read orders
	int setNo;
	while ((setNo = fgetc(f)))
	{
		orders.push_back(sets[setNo]);
	}
	
	// set-up
	currentPriority = 1;
	rewind();
}

/*****************************************/

Module::~Module()
{
	FOREACH(Sample*, it, samples)
		delete (*it);
	FOREACH(Set*, it, sets)
		delete (*it);
}

/*****************************************/

int Module::playFrame(AY *ay)
{
	if (currentOrder == -1)
		jumpToOrder(0);
	
	if (currentOrder >= orders.size())
		return true;
	
	Set *set = orders[currentOrder];
	if (set->tick(ay, currentPriority))
	{
		currentOrder++;
		if (currentOrder < orders.size())
		{
			set = orders[currentOrder];
			set->rewind();
			
			return PLAYBACK_SET_END;
		}
		else
			return PLAYBACK_MODULE_END;
	}
	
	return PLAYBACK_NOTHING;
}

/*****************************************/

void Module::rewindSet()
{
	if (playingSet())
		playingSet()->rewind();
}

/*****************************************/

int Module::playingOrder()
{
	if ((currentOrder < 0) || (currentOrder >= orders.size()))
		return -1;
	
	return currentOrder;
}

/*****************************************/

Set *Module::playingSet()
{
	if ((currentOrder < 0) || (currentOrder >= orders.size()))
		return NULL;
		
	return orders[currentOrder];
}

/*****************************************/

void Module::jumpToOrder(int order)
{
	currentOrder = order;
	orders[currentOrder]->rewind();	
}
