#include <cmath>
#include "Digitized.h"

/********************************************/

Digitized::Digitized(int baseNote, int length, char *frames)
	: samplingFreq(8000.0)
{
	frameData  = frames;
	dataLength = length;
	
	baseNoteFreq = 440.0 * std::pow(2.0, (baseNote - 69.0) / 12.0);
}

/********************************************/

Digitized::~Digitized()
{
	delete[] frameData;
}

/********************************************/

bool Digitized::soundDead(double freq, double time)
{
	time *= freq / baseNoteFreq;
	return (time * samplingFreq + 0.5 >= dataLength);
}

/********************************************/

double Digitized::level(double freq, double time)
{
	time *= freq / baseNoteFreq;
	int pos = (int)(time * samplingFreq + 0.5);
	if (pos < dataLength)
		return (frameData[pos] * (1.0 / 7.5)) - 1.0;
	else
		return 0.0;
}
