#ifndef CHANNEL_H
#define CHANNEL_H

/*******************************************/

#include "../Common.h"

/*******************************************/

class Channel
{
	private:
		AY			*ay;
		int			channelNo;
		
		Sound*		sound;
		
		int			frameNumber;
		int			currentPriority;
		int			soundStartFrame;

	public:	
		Channel(AY *ay, int no);
		~Channel();
		
		void		playSound(Sound *sound, int priority);
		void		clearSound(int priority);

		Sound*		getSound() {return sound;};
		
		void		nextFrame();
		int			frameNo() {return frameNumber;};

		AY	*getAY() {return ay;};
		
		void		volume(int vol);
};

/*******************************************/

#endif
