#include "Channel.h"
#include "AY.h"
#include "Sound.h"

/*****************************************/

Channel::Channel(AY *ay, int no)
	: ay(ay), channelNo(no)
{
	sound = NULL;
	frameNumber = 0;
	currentPriority = -1;
	soundStartFrame = -1;
	
	ay->ayWrite(channelNo * 2, 0x00);
	ay->ayWrite(channelNo * 2 + 1, 0x00);
	ay->ayWrite(7, ay->ayRead(7) | (0x9 << channelNo));
	
	volume(0);
}

/*****************************************/

Channel::~Channel()
{
	ay->ayWrite(channelNo + 8, 0x00);
}

/*****************************************/

void Channel::playSound(Sound *snd, int priority)
{
	if ((priority >= currentPriority) || (!sound))
	{
		sound = snd;
		currentPriority = priority;
		soundStartFrame = frameNumber;
	}
}

/*****************************************/

void Channel::clearSound(int priority)
{
	if (priority >= currentPriority)
		sound = NULL;
}

/*****************************************/

void Channel::nextFrame()
{
	if (sound)
	{
		bool soundDead = sound->processFrame(this, frameNumber - soundStartFrame);
		if (soundDead)
		{
			delete sound;
			sound = NULL;
		}
	}	
	
	frameNumber++;
}

/*****************************************/

void Channel::volume(int level)
{
	ay->ayWrite(8 + channelNo, level & 0xF);
}
