
#include <iostream>
#include "../Common.h"
#include "AY.h"
#include "Channel.h"

/************************************/

AY::AY()
{
	for (int i = 0; i < 16; i++)
	{
		ay_Write(AY_REGSELECT, i);
		reg[i] = regOld[i] = ay_Read();
	}
	
	ayWrite(6, 0);
	ayWrite(7, 0xff);
	
	for (int i = 0; i < 3; i++)
		channels[i] = new Channel(this, i);
	
	frameNumber = 0;
}

/************************************/

AY::~AY()
{
	for (int i = 0; i < 3; i++)
		delete channels[i];
	
	ay_Write(AY_REGSELECT, 7);
	ay_Write(AY_REGVALUE, 0xff);
}

/************************************/

unsigned char AY::ayRead(int regNo)
{
	return reg[regNo];
}

/************************************/

void AY::ayWrite(int regNo, unsigned char value)
{
	reg[regNo] = value;
}

/************************************/

void AY::clearAllSounds()
{
	for (int i = 0; i < 3; i++)
		channels[i]->clearSound(255);
}

/************************************/

void AY::nextFrame()
{
	for (int i = 0; i < 3; i++)
		channels[i]->nextFrame();
	
	for (int i = 0; i < 16; i++)
	{
		if (reg[i] != regOld[i])
		{
			regOld[i] = reg[i];
			ay_Write(AY_REGSELECT, i);
			ay_Write(AY_REGVALUE, reg[i]);
		}
	}
}
