#include <iostream>
#include <string>

#include "Common.h"
#include "engine/AY.h"
#include "engine/Channel.h"
#include "engine/Sound.h"
#include "engine/SoundBlocks.h"
#include "engine/Sample.h"
#include "engine/Set.h"
#include "engine/Module.h"

bool keys[7];
void read_keys()
{
	int keyByte = rt_ReadKeyboard(0);
	for (int i = 0; i <= 6; i++)
		keys[i] = !(keyByte & (1 << (i+1)));
}

int main(int argc, char **argv)
{
	if (argc != 2)
	{
		std::cerr << "Usage: ay <module file>" << std::endl;
		std::exit(1);
	}
	
	std::string filename = argv[1];
	if ((filename.size() >= 4) && (filename.substr(filename.size() - 4) == ".src"))
	{
		// auto-compile source
		std::string command = std::string("python >error.log modconvert.py ") + filename + " temp.smod";		
		std::cout << "Compiling module from source..." << std::endl;
		
		int result = system(command.c_str());
		if (result)
		{
			std::cerr << "Compile failed, see error.log" << std::endl;
			std::exit(1);
		}
		
		filename = "temp.smod";
	}
	FILE *f = fopen(filename.c_str(), "rb");
	if (!f)
	{
		std::cerr << "Unable to open " << argv[1] << std::endl;
		std::exit(1);
	}	
	Module *module = new Module(f);
	fclose(f);
	
	module->rewind();
	bool replayOrder = false;
	int currentOrder = 0;
	bool pause = false;
	
	std::cout << "1\t- rewind to the beginning of the module" << std::endl;
	std::cout << "2\t- rewind to the beginning of the current pattern" << std::endl;
	std::cout << "3\t- jump 1 pattern back" << std::endl;
	std::cout << "4\t- jump 1 pattern forward" << std::endl;
	std::cout << "5\t- toggle pattern repeat" << std::endl;
	std::cout << "6\t- toggle pause" << std::endl;
	std::cout << "ESC\t- quit" << std::endl << std::endl;
	
	rt_Init();
	AY ay;
	
	for (int i = 0; i < 10; i++)
		rt_WaitEvent(RT_VSYNC);
	
	while(true)
	{
		read_keys();
		
		if (keys[1])
		{
			// '1' rewinds the whole module
			module->rewind();
			currentOrder = 0;
			std::cout << "Now playing order: #" << currentOrder << std::endl;
			while (keys[1]) read_keys();
		}
		if (keys[2])
		{
			// '2' rewinds the current pattern
			module->rewindSet();
			std::cout << "Now playing order: #" << currentOrder << std::endl;
			while (keys[2]) read_keys();
		}
		if (keys[3])
		{
			// '3' jumps one pattern back
			if (module->playingOrder() > 0)
			{
				module->jumpToOrder(module->playingOrder() - 1);
				ay.clearAllSounds();

				currentOrder--;
				std::cout << "Now playing order: #" << currentOrder << std::endl;
				while (keys[3]) read_keys();
			}		
		}
		if (keys[4])
		{
			// '4' jumps one pattern forward
			if ((module->playingOrder() != -1) && (module->playingOrder() < (module->orderCount() - 1)))
			{
				module->jumpToOrder(module->playingOrder() + 1);
				ay.clearAllSounds();
				
				currentOrder++;
				std::cout << "Now playing order: #" << currentOrder << std::endl;
				while (keys[4]) read_keys();
			}		
		}
		if (keys[5])
		{
			// '5' toggles "replay pattern" mode
			replayOrder = !replayOrder;
			std::cout << "Pattern repeat " << ((replayOrder) ? "ON." : "OFF.") << std::endl;
			while (keys[5]) read_keys();
		}		
		if (keys[6])
		{
			// '6' pauses/unpauses playback
			pause = !pause;
			if (pause)
				ay.clearAllSounds();
			std::cout << "Playback " << ((pause) ? "STOPPED." : "RESUMED.") << std::endl;
			while (keys[6]) read_keys();
		}
			
		if (keys[0])
			break;
		if (rtSim_QuitWanted())
			break;
		
		if (!pause)
		{
			int moduleEvent = module->playFrame(&ay);
			if ((moduleEvent == PLAYBACK_SET_END) || (moduleEvent == PLAYBACK_MODULE_END))
			{
				if (replayOrder)
					module->jumpToOrder(currentOrder);
				else
					currentOrder = module->playingOrder();
				std::cout << "Now playing order: #" << currentOrder << std::endl;
			}		
		}
		
		ay.nextFrame();
		rt_WaitEvent(RT_HSYNC);
	}
	for (int i = 0; i < 25; i++);
		rt_WaitEvent(RT_VSYNC);
	
	rt_Exit();
	
	return 0;
}
END_OF_MAIN()
