#include "retrohack.h"

void __rtSup_GetRemap(unsigned char *OrigPalette, unsigned char *DestPalette, unsigned char *RemapTable, int *RemapDifference, int masked)
{
	int c;
	for(c = 0; c < 256; c++)
	{
		int r, g, b, sc, col, dist;
		// work out how colour c maps into destpalette
		r = OrigPalette[c * 3];
		g = OrigPalette[(c * 3)+1];
		b = OrigPalette[(c * 3)+2];
		
		sc = 16;
		col = -1;
		while(sc--)
		{
			int mapr, mapg, mapb;
			int newdist;

			mapr = (DestPalette[sc*3] * 255) / 63;
			mapg = (DestPalette[(sc*3)+1] * 255) / 63;
			mapb = (DestPalette[(sc*3)+2] * 255) / 63;
			
			newdist = (mapr - r)*(mapr - r) + (mapg - g)*(mapg - g) + (mapg - g)*(mapg - g);

			if(
				(newdist < dist || col == -1) &&
				(!masked || (c && sc != RemapTable[0]))
			)
			{
				dist = newdist;
				col = sc;
			}
		}
		RemapTable[c] = col;
		RemapDifference[c] = dist;
	}
}

unsigned int __rtSup_TestPalette(unsigned char *Data, unsigned char *OrigPalette, int width, int height, unsigned char *DestPalette, int masked)
{
	// return a rough quantum of difference that would occur if the palette was remapped
	int x, y, RemapDifference[256];
	unsigned char RemapTable[256];
	unsigned int Distance = 0;

	__rtSup_GetRemap(OrigPalette, DestPalette, RemapTable, RemapDifference, masked);

	for(y = 0; y < height; y++)
	{
		for(x = 0; x < width; x++)
		{
			if(!masked || Data[ (y*width) + x])
				Distance += RemapDifference[ Data[ (y*width) + x] ];
		}
	}
	return Distance;
}

int __rtSup_ApplyPalette(unsigned char *Data, unsigned char *OrigPalette, int width, int height, unsigned char *DestPalette, int masked)
{
	// return a rough quantum of difference that would occur if the palette was remapped
	int x, y, RemapDifference[256];
	unsigned char RemapTable[256];

	__rtSup_GetRemap(OrigPalette, DestPalette, RemapTable, RemapDifference, masked);

	for(y = 0; y < height; y++)
	{
		for(x = 0; x < width; x++)
		{
			Data[ (y*width) + x] = RemapTable[ Data[ (y*width) + x] ];
		}
	}
	return RemapTable[0];
}

void *rtSup_LoadPCX(char *Name, int *OtherNibble, int Masked)
{
	unsigned char Palettes[3][16][48] =
	{{
		{0, 33, 0,  0, 22, 0,  0, 10, 0,  22, 0, 0,  0, 27, 0,  0, 16, 0,  0, 5, 0,  22, 0, 0,  0, 22, 0,  0, 11, 0,  0, 0, 0,  22, 0, 0,  0, 17, 27,  0, 5, 27,  0, 0, 27,  22, 0, 27,  },
		{0, 37, 0,  0, 26, 0,  3, 14, 0,  26, 3, 0,  0, 31, 0,  0, 20, 0,  3, 9, 0,  26, 0, 0,  0, 26, 3,  0, 15, 3,  3, 3, 3,  26, 0, 3,  0, 21, 31,  0, 9, 31,  3, 0, 31,  26, 0, 31,  },
		{0, 41, 0,  0, 29, 0,  7, 18, 0,  29, 7, 0,  0, 35, 0,  0, 24, 0,  7, 13, 0,  29, 2, 0,  0, 30, 7,  0, 19, 7,  7, 7, 7,  29, 0, 7,  0, 24, 35,  0, 13, 35,  7, 2, 35,  29, 0, 35,  },
		{0, 45, 0,  0, 33, 0,  11, 22, 0,  33, 11, 0,  0, 39, 0,  0, 28, 0,  11, 17, 0,  33, 5, 0,  0, 34, 11,  0, 23, 11,  11, 11, 11,  33, 0, 11,  0, 28, 39,  0, 17, 39,  11, 6, 39,  33, 0, 39,  },
		{0, 49, 0,  0, 37, 0,  15, 26, 0,  37, 15, 0,  0, 43, 0,  0, 32, 0,  15, 21, 0,  37, 9, 0,  0, 38, 15,  0, 26, 15,  15, 15, 15,  37, 4, 15,  0, 32, 43,  0, 21, 43,  15, 10, 43,  37, 0, 43,  },
		{0, 53, 0,  0, 41, 0,  19, 30, 0,  41, 19, 0,  0, 47, 0,  0, 36, 0,  19, 25, 0,  41, 13, 0,  0, 42, 19,  0, 30, 19,  19, 19, 19,  41, 8, 19,  0, 36, 47,  0, 25, 47,  19, 14, 47,  41, 3, 47,  },
		{0, 56, 0,  1, 45, 0,  23, 34, 0,  45, 23, 0,  0, 51, 0,  1, 40, 0,  23, 29, 0,  45, 17, 0,  0, 46, 23,  1, 34, 23,  23, 23, 23,  45, 12, 23,  0, 40, 51,  1, 29, 51,  23, 18, 51,  45, 6, 51,  },
		{0, 60, 0,  5, 49, 0,  27, 38, 0,  49, 27, 0,  0, 55, 0,  5, 44, 0,  27, 32, 0,  49, 21, 0,  0, 50, 27,  5, 38, 27,  27, 27, 27,  49, 16, 27,  0, 44, 55,  5, 33, 55,  27, 22, 55,  49, 10, 55,  },
		{0, 63, 0,  9, 53, 0,  31, 42, 0,  53, 31, 0,  0, 59, 3,  9, 48, 3,  31, 36, 3,  53, 25, 3,  0, 53, 31,  9, 42, 31,  31, 31, 31,  53, 20, 31,  0, 48, 59,  9, 37, 59,  31, 26, 59,  53, 14, 59,  },
		{0, 63, 0,  13, 57, 0,  35, 46, 0,  57, 35, 0,  0, 63, 7,  13, 52, 7,  35, 40, 7,  57, 29, 7,  0, 57, 35,  13, 46, 35,  35, 35, 35,  57, 24, 35,  0, 52, 63,  13, 41, 63,  35, 30, 63,  57, 18, 63,  },
		{0, 63, 0,  17, 61, 0,  39, 50, 0,  61, 38, 0,  0, 63, 11,  17, 56, 11,  39, 44, 11,  61, 33, 11,  0, 61, 39,  17, 50, 39,  39, 39, 39,  61, 28, 39,  0, 56, 63,  17, 45, 63,  39, 33, 63,  61, 22, 63,  },
		{0, 63, 0,  21, 63, 0,  43, 54, 0,  63, 42, 0,  0, 63, 15,  21, 59, 15,  43, 48, 15,  63, 37, 15,  0, 63, 43,  21, 54, 43,  43, 43, 43,  63, 32, 43,  0, 60, 63,  21, 49, 63,  43, 37, 63,  63, 26, 63,  },
		{3, 63, 0,  25, 63, 0,  47, 58, 0,  63, 46, 0,  3, 63, 19,  25, 63, 19,  47, 52, 19,  63, 41, 19,  3, 63, 47,  25, 58, 47,  47, 47, 47,  63, 36, 47,  3, 63, 63,  25, 53, 63,  47, 41, 63,  63, 30, 63,  },
		{7, 63, 0,  29, 63, 0,  51, 62, 0,  63, 50, 0,  7, 63, 23,  29, 63, 23,  51, 56, 23,  63, 45, 23,  7, 63, 51,  29, 62, 51,  51, 51, 51,  63, 39, 51,  7, 63, 63,  29, 57, 63,  51, 45, 63,  63, 34, 63,  },
		{10, 63, 0,  33, 63, 0,  55, 63, 0,  63, 54, 0,  10, 63, 27,  33, 63, 27,  55, 60, 27,  63, 49, 27,  10, 63, 55,  33, 63, 55,  55, 55, 55,  63, 43, 55,  10, 63, 63,  33, 60, 63,  55, 49, 63,  63, 38, 63,  },
		{14, 63, 3,  36, 63, 3,  59, 63, 3,  63, 58, 3,  14, 63, 31,  36, 63, 31,  59, 63, 31,  63, 53, 31,  14, 63, 59,  36, 63, 59,  59, 59, 59,  63, 47, 59,  14, 63, 63,  36, 63, 63,  59, 53, 63,  63, 42, 63,  },
	},
	{
		{0, 33, 0,  0, 37, 0,  0, 41, 0,  0, 45, 0,  0, 49, 0,  0, 53, 0,  0, 56, 0,  0, 60, 0,  0, 63, 0,  0, 63, 0,  0, 63, 0,  0, 63, 0,  3, 63, 0,  7, 63, 0,  10, 63, 0,  14, 63, 3,  },
		{0, 22, 0,  0, 26, 0,  0, 29, 0,  0, 33, 0,  0, 37, 0,  0, 41, 0,  1, 45, 0,  5, 49, 0,  9, 53, 0,  13, 57, 0,  17, 61, 0,  21, 63, 0,  25, 63, 0,  29, 63, 0,  33, 63, 0,  36, 63, 3,  },
		{0, 10, 0,  3, 14, 0,  7, 18, 0,  11, 22, 0,  15, 26, 0,  19, 30, 0,  23, 34, 0,  27, 38, 0,  31, 42, 0,  35, 46, 0,  39, 50, 0,  43, 54, 0,  47, 58, 0,  51, 62, 0,  55, 63, 0,  59, 63, 3,  },
		{22, 0, 0,  26, 3, 0,  29, 7, 0,  33, 11, 0,  37, 15, 0,  41, 19, 0,  45, 23, 0,  49, 27, 0,  53, 31, 0,  57, 35, 0,  61, 38, 0,  63, 42, 0,  63, 46, 0,  63, 50, 0,  63, 54, 0,  63, 58, 3,  },
		{0, 27, 0,  0, 31, 0,  0, 35, 0,  0, 39, 0,  0, 43, 0,  0, 47, 0,  0, 51, 0,  0, 55, 0,  0, 59, 3,  0, 63, 7,  0, 63, 11,  0, 63, 15,  3, 63, 19,  7, 63, 23,  10, 63, 27,  14, 63, 31,  },
		{0, 16, 0,  0, 20, 0,  0, 24, 0,  0, 28, 0,  0, 32, 0,  0, 36, 0,  1, 40, 0,  5, 44, 0,  9, 48, 3,  13, 52, 7,  17, 56, 11,  21, 59, 15,  25, 63, 19,  29, 63, 23,  33, 63, 27,  36, 63, 31,  },
		{0, 5, 0,  3, 9, 0,  7, 13, 0,  11, 17, 0,  15, 21, 0,  19, 25, 0,  23, 29, 0,  27, 32, 0,  31, 36, 3,  35, 40, 7,  39, 44, 11,  43, 48, 15,  47, 52, 19,  51, 56, 23,  55, 60, 27,  59, 63, 31,  },
		{22, 0, 0,  26, 0, 0,  29, 2, 0,  33, 5, 0,  37, 9, 0,  41, 13, 0,  45, 17, 0,  49, 21, 0,  53, 25, 3,  57, 29, 7,  61, 33, 11,  63, 37, 15,  63, 41, 19,  63, 45, 23,  63, 49, 27,  63, 53, 31,  },
		{0, 22, 0,  0, 26, 3,  0, 30, 7,  0, 34, 11,  0, 38, 15,  0, 42, 19,  0, 46, 23,  0, 50, 27,  0, 53, 31,  0, 57, 35,  0, 61, 39,  0, 63, 43,  3, 63, 47,  7, 63, 51,  10, 63, 55,  14, 63, 59,  },
		{0, 11, 0,  0, 15, 3,  0, 19, 7,  0, 23, 11,  0, 26, 15,  0, 30, 19,  1, 34, 23,  5, 38, 27,  9, 42, 31,  13, 46, 35,  17, 50, 39,  21, 54, 43,  25, 58, 47,  29, 62, 51,  33, 63, 55,  36, 63, 59,  },
		{0, 0, 0,  3, 3, 3,  7, 7, 7,  11, 11, 11,  15, 15, 15,  19, 19, 19,  23, 23, 23,  27, 27, 27,  31, 31, 31,  35, 35, 35,  39, 39, 39,  43, 43, 43,  47, 47, 47,  51, 51, 51,  55, 55, 55,  59, 59, 59,  },
		{22, 0, 0,  26, 0, 3,  29, 0, 7,  33, 0, 11,  37, 4, 15,  41, 8, 19,  45, 12, 23,  49, 16, 27,  53, 20, 31,  57, 24, 35,  61, 28, 39,  63, 32, 43,  63, 36, 47,  63, 39, 51,  63, 43, 55,  63, 47, 59,  },
		{0, 17, 27,  0, 21, 31,  0, 24, 35,  0, 28, 39,  0, 32, 43,  0, 36, 47,  0, 40, 51,  0, 44, 55,  0, 48, 59,  0, 52, 63,  0, 56, 63,  0, 60, 63,  3, 63, 63,  7, 63, 63,  10, 63, 63,  14, 63, 63,  },
		{0, 5, 27,  0, 9, 31,  0, 13, 35,  0, 17, 39,  0, 21, 43,  0, 25, 47,  1, 29, 51,  5, 33, 55,  9, 37, 59,  13, 41, 63,  17, 45, 63,  21, 49, 63,  25, 53, 63,  29, 57, 63,  33, 60, 63,  36, 63, 63,  },
		{0, 0, 27,  3, 0, 31,  7, 2, 35,  11, 6, 39,  15, 10, 43,  19, 14, 47,  23, 18, 51,  27, 22, 55,  31, 26, 59,  35, 30, 63,  39, 33, 63,  43, 37, 63,  47, 41, 63,  51, 45, 63,  55, 49, 63,  59, 53, 63,  },
		{22, 0, 27,  26, 0, 31,  29, 0, 35,  33, 0, 39,  37, 0, 43,  41, 3, 47,  45, 6, 51,  49, 10, 55,  53, 14, 59,  57, 18, 63,  61, 22, 63,  63, 26, 63,  63, 30, 63,  63, 34, 63,  63, 38, 63,  63, 42, 63,  },
	},
	{
		{0, 33, 0,  0, 10, 0,  0, 22, 0,  0, 0, 0,  0, 49, 0,  15, 26, 0,  0, 38, 15,  15, 15, 15,  0, 63, 0,  31, 42, 0,  0, 53, 31,  31, 31, 31,  3, 63, 0,  47, 58, 0,  3, 63, 47,  47, 47, 47,  },
		{0, 22, 0,  22, 0, 0,  0, 11, 0,  22, 0, 0,  0, 37, 0,  37, 15, 0,  0, 26, 15,  37, 4, 15,  9, 53, 0,  53, 31, 0,  9, 42, 31,  53, 20, 31,  25, 63, 0,  63, 46, 0,  25, 58, 47,  63, 36, 47,  },
		{0, 27, 0,  0, 5, 0,  0, 17, 27,  0, 0, 27,  0, 43, 0,  15, 21, 0,  0, 32, 43,  15, 10, 43,  0, 59, 3,  31, 36, 3,  0, 48, 59,  31, 26, 59,  3, 63, 19,  47, 52, 19,  3, 63, 63,  47, 41, 63,  },
		{0, 16, 0,  22, 0, 0,  0, 5, 27,  22, 0, 27,  0, 32, 0,  37, 9, 0,  0, 21, 43,  37, 0, 43,  9, 48, 3,  53, 25, 3,  9, 37, 59,  53, 14, 59,  25, 63, 19,  63, 41, 19,  25, 53, 63,  63, 30, 63,  },
		{0, 37, 0,  3, 14, 0,  0, 26, 3,  3, 3, 3,  0, 53, 0,  19, 30, 0,  0, 42, 19,  19, 19, 19,  0, 63, 0,  35, 46, 0,  0, 57, 35,  35, 35, 35,  7, 63, 0,  51, 62, 0,  7, 63, 51,  51, 51, 51,  },
		{0, 26, 0,  26, 3, 0,  0, 15, 3,  26, 0, 3,  0, 41, 0,  41, 19, 0,  0, 30, 19,  41, 8, 19,  13, 57, 0,  57, 35, 0,  13, 46, 35,  57, 24, 35,  29, 63, 0,  63, 50, 0,  29, 62, 51,  63, 39, 51,  },
		{0, 31, 0,  3, 9, 0,  0, 21, 31,  3, 0, 31,  0, 47, 0,  19, 25, 0,  0, 36, 47,  19, 14, 47,  0, 63, 7,  35, 40, 7,  0, 52, 63,  35, 30, 63,  7, 63, 23,  51, 56, 23,  7, 63, 63,  51, 45, 63,  },
		{0, 20, 0,  26, 0, 0,  0, 9, 31,  26, 0, 31,  0, 36, 0,  41, 13, 0,  0, 25, 47,  41, 3, 47,  13, 52, 7,  57, 29, 7,  13, 41, 63,  57, 18, 63,  29, 63, 23,  63, 45, 23,  29, 57, 63,  63, 34, 63,  },
		{0, 41, 0,  7, 18, 0,  0, 30, 7,  7, 7, 7,  0, 56, 0,  23, 34, 0,  0, 46, 23,  23, 23, 23,  0, 63, 0,  39, 50, 0,  0, 61, 39,  39, 39, 39,  10, 63, 0,  55, 63, 0,  10, 63, 55,  55, 55, 55,  },
		{0, 29, 0,  29, 7, 0,  0, 19, 7,  29, 0, 7,  1, 45, 0,  45, 23, 0,  1, 34, 23,  45, 12, 23,  17, 61, 0,  61, 38, 0,  17, 50, 39,  61, 28, 39,  33, 63, 0,  63, 54, 0,  33, 63, 55,  63, 43, 55,  },
		{0, 35, 0,  7, 13, 0,  0, 24, 35,  7, 2, 35,  0, 51, 0,  23, 29, 0,  0, 40, 51,  23, 18, 51,  0, 63, 11,  39, 44, 11,  0, 56, 63,  39, 33, 63,  10, 63, 27,  55, 60, 27,  10, 63, 63,  55, 49, 63,  },
		{0, 24, 0,  29, 2, 0,  0, 13, 35,  29, 0, 35,  1, 40, 0,  45, 17, 0,  1, 29, 51,  45, 6, 51,  17, 56, 11,  61, 33, 11,  17, 45, 63,  61, 22, 63,  33, 63, 27,  63, 49, 27,  33, 60, 63,  63, 38, 63,  },
		{0, 45, 0,  11, 22, 0,  0, 34, 11,  11, 11, 11,  0, 60, 0,  27, 38, 0,  0, 50, 27,  27, 27, 27,  0, 63, 0,  43, 54, 0,  0, 63, 43,  43, 43, 43,  14, 63, 3,  59, 63, 3,  14, 63, 59,  59, 59, 59,  },
		{0, 33, 0,  33, 11, 0,  0, 23, 11,  33, 0, 11,  5, 49, 0,  49, 27, 0,  5, 38, 27,  49, 16, 27,  21, 63, 0,  63, 42, 0,  21, 54, 43,  63, 32, 43,  36, 63, 3,  63, 58, 3,  36, 63, 59,  63, 47, 59,  },
		{0, 39, 0,  11, 17, 0,  0, 28, 39,  11, 6, 39,  0, 55, 0,  27, 32, 0,  0, 44, 55,  27, 22, 55,  0, 63, 15,  43, 48, 15,  0, 60, 63,  43, 37, 63,  14, 63, 31,  59, 63, 31,  14, 63, 63,  59, 53, 63,  },
		{0, 28, 0,  33, 5, 0,  0, 17, 39,  33, 0, 39,  5, 44, 0,  49, 21, 0,  5, 33, 55,  49, 10, 55,  21, 59, 15,  63, 37, 15,  21, 49, 63,  63, 26, 63,  36, 63, 31,  63, 53, 31,  36, 63, 63,  63, 42, 63,  },
	}};
	enum rt_TargetFormats format;
	FILE *input;
	unsigned int BitsPerPixel, MinX, MinY, MaxX, MaxY, ColourPlanes, BytesPerLine, y, c, HighOne, Mask;
	unsigned int HighCount;
	unsigned char *Data, Palette[768];
	void *R;

	if(!(input = fopen(Name, "rb"))) return NULL;
	fseek(input, 3, SEEK_CUR);

	BitsPerPixel = fgetc(input);
	if(BitsPerPixel != 8)
	{
		fclose(input);
		return NULL;
	}

	MinX = fgetc(input); MinX |= fgetc(input) << 8;
	MinY = fgetc(input); MinY |= fgetc(input) << 8;
	MaxX = fgetc(input); MaxX |= fgetc(input) << 8;
	MaxY = fgetc(input); MaxY |= fgetc(input) << 8;

	MaxX = MaxX - MinX + 1; MaxY = MaxY - MinY + 1;
	if(MaxX >= 512 || MaxY >= 512)
	{
		fclose(input);
		return NULL;
	}

	fseek(input, 53, SEEK_CUR);
	ColourPlanes = fgetc(input);
	BytesPerLine = fgetc(input);
	BytesPerLine |= fgetc(input) << 8;
	if(ColourPlanes > 1)
	{
		fclose(input);
		return NULL;
	}

	// read palette
	fseek(input, -768, SEEK_END);
	fread(Palette, sizeof(unsigned char), 768, input);

	// seek to end of header, to read pixel data
	fseek(input, 128, SEEK_SET);

	// allocate space for, and then read, pixel data
	Data = (unsigned char *)malloc(sizeof(unsigned char)*MaxY*BytesPerLine*ColourPlanes);
	for(y = 0; y < MaxY; y ++)
	{
		int x = 0;
		while(x < BytesPerLine)
		{
			unsigned char Byte1;
			Byte1 = fgetc(input);

			if(Byte1 < 192)
			{
				Data[(y*MaxX) + x] = Byte1;
				x++;
			}
			else
			{
				unsigned char Byte2 = fgetc(input);
				memset(&Data[(y*MaxX) + x], Byte2, Byte1&63);
				x += (Byte1&63);
			}
		}
	}
	fclose(input);	// close file

	// find optimum palette
	HighOne = -1;
	c = 48;
	while(c--)
	{
		float NewNum = __rtSup_TestPalette(Data, Palette, MaxX, MaxY, Palettes[c >> 4][c&15], Masked);
		if(NewNum < HighCount || HighOne == -1)
		{
			HighCount = NewNum;
			HighOne = c;
		}
	}

	// select format
	switch(HighOne >> 4)
	{
		case 0: format = RT_CbCr; break;
		case 1: format = RT_Y; break;
		case 2: format = RT_MIX; break;
	}

	// convert and upload Data
	Mask = __rtSup_ApplyPalette(Data, Palette, MaxX, MaxY, Palettes[HighOne >> 4][HighOne&15], Masked);
	R = rt_UploadGraphic(format, Data, 1, MaxX, MaxY, Mask);
	*OtherNibble = HighOne&15;

	free(Data);

	// return graphic
	return R;
}

int main(int argc, const char *argv[])
{
	int col;
	void *G;
	rt_Init();
	
	G = rtSup_LoadPCX("luigi.pcx", &col, TRUE);
	while(!rtSim_QuitWanted())
	{
		rt_MaskedBlit(G, col, 0, 0, itofix(1), itofix(1), 0, 0);
		rt_Flip();
		rt_WaitEvent(RT_VSYNC);
	}

	rt_FreeGraphic(G);
	rt_Exit();
	return 0;
}
END_OF_MAIN()
