
#include <allegro.h>

static volatile int size_changed=0, close_button_pressed;
static BITMAP *background; 

void xbutton_cb(void) {close_button_pressed++;}
void resize_cb(void) {size_changed++;}

void redraw(void)
{
    stretch_blit(background, screen,
        0, 0, background->w, background->h,
        0, 0, SCREEN_W, SCREEN_H);
}

int main(void)
{
	allegro_resizable_window_flag = TRUE;
    allegro_init();
    set_color_depth(desktop_color_depth());

    
	set_gfx_mode(GFX_GDI, 320, 200, 0, 0);
	//set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 200, 0, 0);

    install_keyboard();
    install_mouse();
    show_os_cursor(MOUSE_CURSOR_ARROW);
    install_timer();

    background = load_bitmap("../../../examples/mysha.pcx", NULL);

    set_close_button_callback(xbutton_cb);
    set_resize_callback(resize_cb, 160, 100);

    redraw();
    while (!close_button_pressed)
    {
        if (size_changed)
        {
            resize_screen();
            redraw();
            size_changed = 0;
		}
        rest(10);
    }
    destroy_bitmap(background);
    return 0;
}
END_OF_MAIN()
