/*

Upon using this code in any fashion, you accept that, this code for in all respects,
becomes yours. If this breaks or damages anything, you cant come back and blame me
cause it was your code that did it.

This is public domain code. In the truer sence. No one owns it, it owns itself. If it
breaks your computer, sue the code. I didnt do it, the program did.

If you don't agree with this, don't use the code. :)

-Timorg (anthonytcassidy@hotmail.com)

*/

#include <windows.h>
#include "createicon.h"

int hscale = 1;
int vscale = 1;

void GetMaskBitmaps(HBITMAP hSourceBitmap,
              COLORREF clrTransparent,
              HBITMAP &hAndMaskBitmap,
              HBITMAP &hXorMaskBitmap)
{
  HDC hDC        = ::GetDC(NULL);
  HDC hMainDC      = ::CreateCompatibleDC(hDC);
  HDC hAndMaskDC      = ::CreateCompatibleDC(hDC);
  HDC hXorMaskDC      = ::CreateCompatibleDC(hDC);

  //Get the dimensions of the source bitmap
  BITMAP bm;
  ::GetObject(hSourceBitmap,sizeof(BITMAP),&bm);


  hAndMaskBitmap  = ::CreateCompatibleBitmap(hDC,bm.bmWidth / hscale, bm.bmHeight / vscale);
  hXorMaskBitmap  = ::CreateCompatibleBitmap(hDC,bm.bmWidth / hscale, bm.bmHeight / vscale);

  //Select the bitmaps to DC
  HBITMAP hOldMainBitmap = (HBITMAP)::SelectObject(hMainDC,hSourceBitmap);
  HBITMAP hOldAndMaskBitmap  = (HBITMAP)::SelectObject(hAndMaskDC,
    hAndMaskBitmap);
  HBITMAP hOldXorMaskBitmap  = (HBITMAP)::SelectObject(hXorMaskDC,
    hXorMaskBitmap);

  //Scan each pixel of the souce bitmap and create the masks
  COLORREF MainBitPixel;
//  for(int x=0;x<bm.bmWidth;++x)
  for(int x=0;x<bm.bmWidth;x += hscale)
  {
    for(int y=0;y<bm.bmHeight; y += vscale)
    {
      MainBitPixel = ::GetPixel(hMainDC,x,y);
      if(MainBitPixel == clrTransparent)
      {
        ::SetPixel(hAndMaskDC,x / hscale,y / vscale,RGB(255,255,255));
        ::SetPixel(hXorMaskDC,x / hscale,y / vscale,RGB(0,0,0));
      }
      else
      {
        ::SetPixel(hAndMaskDC,x / hscale,y / vscale,RGB(0,0,0));
        ::SetPixel(hXorMaskDC,x / hscale,y / vscale,MainBitPixel);
      }
    }
  }

  ::SelectObject(hMainDC,hOldMainBitmap);
  ::SelectObject(hAndMaskDC,hOldAndMaskBitmap);
  ::SelectObject(hXorMaskDC,hOldXorMaskBitmap);

  ::DeleteDC(hXorMaskDC);
  ::DeleteDC(hAndMaskDC);
  ::DeleteDC(hMainDC);

  ::ReleaseDC(NULL,hDC);
}

HICON CreateIconFromBitmap(HBITMAP hSourceBitmap,
											 COLORREF clrTransparent,
											 DWORD   xHotspot,DWORD   yHotspot)
{
	HCURSOR hRetIcon = NULL;

	do
	{
		if(NULL == hSourceBitmap)
		{
			break;
		}

		//Create the AND and XOR masks for the bitmap
		HBITMAP hAndMask = NULL;
		HBITMAP hXorMask = NULL;
		GetMaskBitmaps(hSourceBitmap,clrTransparent,hAndMask,hXorMask);
		if(NULL == hAndMask || NULL == hXorMask)
		{
			break;
		}

		//Create the cursor using the masks and the hotspot values provided
		ICONINFO iconinfo = {0};
		iconinfo.fIcon		= FALSE;
		iconinfo.xHotspot	= xHotspot;
		iconinfo.yHotspot	= yHotspot;
		iconinfo.hbmMask	= hAndMask;
		iconinfo.hbmColor	= hXorMask;

		hRetIcon = ::CreateIconIndirect(&iconinfo);

	}
	while(0);

	return hRetIcon;
}

HICON CreateIcon(void *hSourceBitmap, int _hscale, int _vscale)
{
	hscale = _hscale;
	vscale = _vscale;
	return CreateIconFromBitmap((HBITMAP)hSourceBitmap, RGB(255,255,255), 0, 0);
}
