#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "dump.h"
#include "../map.h"

#include "../mt.h"

int main(int argc, char *argv[])
{
 MAP *small, *big;
 unsigned int norm_pills, spec_pills;
 int w, h;

 w = h = 0;

 if(argc == 3)
   {
    w = atoi(argv[1]);
    h = atoi(argv[2]);
   }

 if(!w || !h)
   {
    w = 640;
    h = 480;
   }

 init_genrand(time(NULL));

 if(create_maps(w, h, &small, &big, &norm_pills, &spec_pills))
   {
    printf("Errore nella creazione delle mappe!\n");
    return 0;
   }

 printf("Larghezza mappa piccola: %d\nAltezza mappa piccola: %d\n\n", small->w, small->h);
 printf("Larghezza mappa grande: %d\nAltezza mappa grande: %d\n\n", big->w, big->h);
 printf("Totale pillole normali: %d\nTotale pillole speciali: %d", norm_pills, spec_pills);

 dump_gfx_map_to_file(big, generate_unused_filename("bmp_images/t1_", ".bmp"), w, h);
 
 destroy_maps(small, big);

 return 0;
}

