#include <stdio.h>

#include <allegro.h>

#include "../map.h"



#define MAP_SMALL 0x01
#define MAP_BIG   0x02

#define TILE_WALL             0x01
#define TILE_DESTROYABLE_WALL 0x02
#define TILE_REMOVE_WALL      0xFE

#define TILE_NORMAL_PILL  0x80
#define TILE_SPECIAL_PILL 0x40
#define TILE_REMOVE_NORMAL_PILL  0x7F
#define TILE_REMOVE_SPECIAL_PILL 0xBF

#define TILE_MARK        0x04



void dump_map(MAP *map, char *file)
{
 unsigned short int i, j, w, h;
 FILE *out;

 out = fopen(file, "wt");

 if(!out)
   printf("Argh!");

 w = map->w;
 h = map->h;

 for(i = 0; i < h; i++)
   {
    for(j = 0; j < w; j++)
      fprintf(out, "%i", *(map->tile + (i * w) + j));

    fprintf(out, "\n");
   }

 fclose(out);
}



void dump_gfx_map(MAP *map, int width, int height)
{
 unsigned int i, j;
 BITMAP *wall, *iwall, *xwall;

 allegro_init();
 install_keyboard();
 install_mouse();

 set_color_depth(16);
 if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, width, height, 0, 0) < 0)
   set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, width, height, 0, 0);

 wall = load_bitmap("images/wall.bmp", NULL);
 iwall = load_bitmap("images/iwall.bmp", NULL);
 xwall = load_bitmap("images/xwall.bmp", NULL);

 show_mouse(screen);

 for(i = 0; i < map->h; i++)
   for(j = 0; j < map->w; j++)
     {
      if(map->tile[i * map->w + j] & TILE_MARK)
        masked_blit(xwall, screen, 0, 0, j * 8, i * 8, 8, 8);
      else
        if(map->tile[i * map->w + j] & TILE_DESTROYABLE_WALL && map->tile[i * map->w + j] & TILE_WALL)
        masked_blit(iwall, screen, 0, 0, j * 8, i * 8, 8, 8);
      else
        if(map->tile[i * map->w + j] & TILE_WALL)
          masked_blit(wall, screen, 0, 0, j * 8, i * 8, 8, 8);
     }

 readkey();

 destroy_bitmap(wall);
 destroy_bitmap(iwall);
 destroy_bitmap(xwall);

 set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
 allegro_exit();
}



void dump_gfx_map_to_file(MAP *map, char *file, int width, int height)
{
 unsigned int i, j;
 BITMAP *wall, *iwall, *xwall, *img;
 BITMAP *pills[2];

 allegro_init();

 set_color_depth(32);

 wall = load_bitmap("images/wall.bmp", NULL);
 iwall = load_bitmap("images/iwall.bmp", NULL);
 xwall = load_bitmap("images/xwall.bmp", NULL);

 pills[0] = load_bitmap("images/pill.bmp", NULL);
 pills[1] = load_bitmap("images/pill2.bmp", NULL);

 img = create_bitmap(width, height);

 if(!wall || !xwall || !iwall)
   { allegro_message("Problema bitmap!"); return; }
   
 if(!img)
   { allegro_message("Problema screen! w: %d, h: %d", width, height); return; }

 for(i = 0; i < map->h; i++)
   for(j = 0; j < map->w; j++)
     {
      if(map->tile[i * map->w + j] & TILE_DESTROYABLE_WALL && map->tile[i * map->w + j] & TILE_WALL)
        masked_blit(wall, img, 0, 0, j * 8, i * 8, 8, 8);
      else
        if(map->tile[i * map->w + j] & TILE_WALL)
          masked_blit(wall, img, 0, 0, j * 8, i * 8, 8, 8);

      if(map->tile[i * map->w + j] & TILE_SPECIAL_PILL)
        masked_blit(pills[1], img, 0, 0, j * 8 - 1, i * 8, pills[1]->w, pills[1]->h);

      else if(map->tile[i * map->w + j] & TILE_NORMAL_PILL)
        masked_blit(pills[0], img, 0, 0, j * 8 - 1, i * 8, pills[0]->w, pills[0]->h);
     }

 destroy_bitmap(wall);
 destroy_bitmap(iwall);
 destroy_bitmap(xwall);
 
 destroy_bitmap(pills[0]);
 destroy_bitmap(pills[1]);

 save_bmp(file, img, NULL);

 destroy_bitmap(img);

 set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);

 allegro_exit();
}



char *generate_unused_filename(char *prefix, char *ext)
{
 static char buffer[1024];
 static unsigned int last_number = 0;

 FILE *file;

 *buffer = '\0';

 sprintf(buffer, "%s%03d.%s", prefix, last_number, ext);
 file = fopen(buffer, "r");

 while(file)
   {
    fclose(file);

    last_number++;
    sprintf(buffer, "%s%03d.%s", prefix, last_number, ext);
    file = fopen(buffer, "r");    
   }

 return buffer;
}

