/**********************************************
*                                             *
* INSERT PROJECT NAME AND VERSION             *
*                                             *
* Map generator header file                   *
* Tuesday the 29th, March 2005                *
*                                             *
* Copyright (c) by Marco Radaelli             *
*                                             *
******                                  *******
*                                             *
* Contains macros and prototypes of functions *
* used to generate a map for a level          *
*                                             *
**********************************************/

#ifndef MAP_H
#define MAP_H



/* Map structure
 *
 * This game uses two maps:
 * - the 'big' map
 *     is a 1:1 representation of what is blitted on the screen
 * - the 'small' map is a 1:~2 representation of
 *     of the big map, because sometimes 1 tile maps to
 *     3 screen tiles (in the case of the destroyable walls),
 *     sometimes 1 tile maps to 9 tiles (in the case of
 *     the corridors, which are void tiles) and sometimes
 *     1 tile maps to 1 screen tile (in the case of the
 *     non-destroyable walls)
*/
typedef struct MAP
{
 unsigned short int w, h;  /* Width and height of the map */
 unsigned char *tile;      /* Pointer to the array of tiles */
} MAP;


/* The map design
*/



int create_maps(int screen_w, int screen_h, MAP **small_map, MAP **big_map,
                unsigned int *normal_pills_num, unsigned int *special_pills_num);
void destroy_maps(MAP *small, MAP *big);

#endif /* MAP_H */

