#include "globals.h"


VulcanGun::VulcanGun()
{
    //std::cout << "Creating VulcanGun object...\n";
}

VulcanGun::VulcanGun(int x, int y, int ammo, int maxAmmo, int fireRate, int wLevel)
{
    this->x = x;
    this->y = y;
    this->ammo = ammo;
    this->maxAmmo = maxAmmo;
    this->fireRate = fireRate;    
    this->waitCount = 0;
    weaponLevel = wLevel;
    hostile = false;
}    

VulcanGun::~VulcanGun()
{
}

void VulcanGun::dragWeapon(int x, int y)
{
    this->x = x;
    this->y = y;
}    

void VulcanGun::fire(int a)
{    
    if (waitCount <= 0)
    {
        int pfPoolSize;
        
        switch(weaponLevel)
        {
            case 1:
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, a, hostile) );
               
                pfPoolSize= ProjectileFactory::projectilePool.size();
                
                ProjectileFactory::projectilePool[pfPoolSize - 1]->move(x, y);
                
                waitCount = fireRate;
                
                play_sample( SoundManager::getSample(VULCAN_GUN_FIRE_SFX), 255, 0, 2000, 0);
                
                break;
            case 2:
                
                
                if (a == 0)
                {
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, 35, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, a, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, 215, hostile) );
                }
                else if(a ==145 )
                {
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, 90, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, a, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, 160, hostile) );
                }
                else
                {
                }
                
                

                /*
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, a - 55, hostile) );
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, a, hostile) );
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, a + (a/6), hostile) );                
                */
                
                pfPoolSize= ProjectileFactory::projectilePool.size();
                
                ProjectileFactory::projectilePool[pfPoolSize - 1]->move(x, y - 10);
                ProjectileFactory::projectilePool[pfPoolSize - 2]->move(x, y);
                ProjectileFactory::projectilePool[pfPoolSize - 3]->move(x, y + 20);
                
                waitCount = fireRate;
                
                play_sample( SoundManager::getSample(VULCAN_GUN_FIRE_SFX), 255, 0, 2000, 0);                
                break;
            case 3:
                 
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, 90, hostile) );
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, 35, hostile) );
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, a, hostile) );
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, a, hostile) );
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, 230, hostile) );
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(VULCAN, 160, hostile) );
                
                pfPoolSize= ProjectileFactory::projectilePool.size();

                //TODO: position of x must be based on angle
                ProjectileFactory::projectilePool[pfPoolSize - 1]->move(x - 20, y - 10);                
                ProjectileFactory::projectilePool[pfPoolSize - 2]->move(x, y - 10);
                ProjectileFactory::projectilePool[pfPoolSize - 3]->move(x + 10, y);                
                ProjectileFactory::projectilePool[pfPoolSize - 4]->move(x + 10, y + 10);            
                ProjectileFactory::projectilePool[pfPoolSize - 5]->move(x, y + 20);
                ProjectileFactory::projectilePool[pfPoolSize - 6]->move(x - 20, y + 20);
                
                waitCount = fireRate;
                
                play_sample( SoundManager::getSample(VULCAN_GUN_FIRE_SFX), 255, 0, 2000, 0);
                break;
            default:
                break;
        }    
    
        
    

    }    
}

void VulcanGun::recharge()
{
    --this->waitCount;
}

void VulcanGun::fullCharge()
{
    this->waitCount = 0;
}        

char* VulcanGun::getWeaponName()
{
    return "Vulcan Gun";
}    
